/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.utils;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import reborncore.RebornRegistry;
import techreborn.TechReborn;

public class InitUtils {
	public static <I extends class_1792> I setup(I item, String name) {
		RebornRegistry.registerIdent(item, class_2960.method_60655(TechReborn.MOD_ID, name));

		if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
			String expect = class_156.method_646("item", class_2960.method_60655(TechReborn.MOD_ID, name));
			String actual = item.method_7876();

			if (!expect.equals(actual)) {
				// This happens when the item settings registry key does not match key used to register the item
				throw new IllegalStateException("Item translation key mismatch: expected " + expect + ", got " + actual);
			}
		}

		return item;
	}

	public static <B extends class_2248> B setup(B block, String name) {
		RebornRegistry.registerIdent(block, class_2960.method_60655(TechReborn.MOD_ID, name));

		if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
			String expect = class_156.method_646("block", class_2960.method_60655(TechReborn.MOD_ID, name));
			String actual = block.method_63499();

			if (!expect.equals(actual)) {
				// This happens when the block settings registry key does not match key used to register the block
				throw new IllegalStateException("Block translation key mismatch: expected " + expect + ", got " + actual);
			}
		}

		return block;
	}

	public static class_3414 setup(String name) {
		class_2960 identifier = class_2960.method_60655(TechReborn.MOD_ID, name);
		return class_2378.method_10230(class_7923.field_41172, identifier, class_3414.method_47908(identifier));
	}

	public static boolean isDatagenRunning() {
		return System.getProperty("fabric-api.datagen") != null;
	}

	private InitUtils() {/* No instantiation. */}
}
