/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.recipe.recipes;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeInput;
import reborncore.common.crafting.SizedIngredient;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9887;

public record RollingMachineRecipe(class_3956<? extends RollingMachineRecipe> type, int power, int time, class_1869 shapedRecipe) implements RebornRecipe {
	public static Function<class_3956<RollingMachineRecipe>, MapCodec<RollingMachineRecipe>> CODEC = type -> RecordCodecBuilder.mapCodec(instance -> instance.group(
		class_5699.field_33442.fieldOf("power").forGetter(RebornRecipe::power),
		class_5699.field_33442.fieldOf("time").forGetter(RebornRecipe::time),
		class_1865.field_9035.method_53736().forGetter(RollingMachineRecipe::getShapedRecipe)
	).apply(instance, (power, time, shaped) -> new RollingMachineRecipe(type, power, time, shaped)));
	public static Function<class_3956<RollingMachineRecipe>, class_9139<class_9129, RollingMachineRecipe>> PACKET_CODEC = type -> class_9139.method_56906(
		SizedIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()), RebornRecipe::ingredients,
		class_1799.field_48349.method_56433(class_9135.method_56363()), RebornRecipe::outputs,
		class_9135.field_49675, RebornRecipe::power,
		class_9135.field_49675, RebornRecipe::time,
		class_1865.field_9035.method_56104(), RollingMachineRecipe::getShapedRecipe,
		(ingredients, outputs, power, time, shaped) -> new RollingMachineRecipe(type, power, time, shaped)
	);

	@Override
	public List<class_1799> outputs() {
		// Input does not affect the result
		return Collections.singletonList(shapedRecipe.method_17727(null, null));
	}

	@Override
	public class_1799 assemble(RebornRecipeInput inventory, class_7225.class_7874 lookup) {
		// Input does not affect the result
		return shapedRecipe.method_17727(null, lookup);
	}

	@Override
	public List<SizedIngredient> ingredients() {
		return List.of();
	}

	@Override
	public class_9887 method_61671() {
		return shapedRecipe.method_61671();
	}

	public class_1869 getShapedRecipe() {
		return shapedRecipe;
	}
}
