/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.recipe.recipes;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import reborncore.common.crafting.RebornFluidRecipe;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.SizedIngredient;
import reborncore.common.fluid.FluidUtils;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.util.Tank;
import techreborn.blockentity.machine.multiblock.FluidReplicatorBlockEntity;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record FluidReplicatorRecipe(class_3956<? extends FluidReplicatorRecipe> type, List<SizedIngredient> ingredients, List<class_1799> outputs, int power, int time, FluidInstance fluid) implements RebornFluidRecipe {
	public static final Function<class_3956<FluidReplicatorRecipe>, MapCodec<FluidReplicatorRecipe>> CODEC = type -> RecordCodecBuilder.mapCodec(instance -> instance.group(
		Codec.list(SizedIngredient.CODEC.codec()).fieldOf("ingredients").forGetter(RebornRecipe::ingredients),
		Codec.list(class_1799.field_24671).fieldOf("outputs").forGetter(RebornRecipe::outputs),
		class_5699.field_33442.fieldOf("power").forGetter(RebornRecipe::power),
		class_5699.field_33442.fieldOf("time").forGetter(RebornRecipe::time),
		FluidInstance.CODEC.fieldOf("fluid").forGetter(RebornFluidRecipe::fluid)
	).apply(instance, (ingredients, outputs, power, time, fluid) -> new FluidReplicatorRecipe(type, ingredients, outputs, power, time, fluid)));
	public static final Function<class_3956<FluidReplicatorRecipe>, class_9139<class_9129, FluidReplicatorRecipe>> PACKET_CODEC = type -> class_9139.method_56906(
		SizedIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()), RebornRecipe::ingredients,
		class_1799.field_48349.method_56433(class_9135.method_56363()), RebornRecipe::outputs,
		class_9135.field_49675, RebornRecipe::power,
		class_9135.field_49675, RebornRecipe::time,
		FluidInstance.PACKET_CODEC, RebornFluidRecipe::fluid,
		(ingredients, outputs, power, time, fluid) -> new FluidReplicatorRecipe(type, ingredients, outputs, power, time, fluid)
	);

	@Override
	public Tank getTank(class_2586 be) {
		FluidReplicatorBlockEntity blockEntity = (FluidReplicatorBlockEntity) be;
		return blockEntity.getTank();
	}

	@Override
	public boolean canCraft(class_2586 be) {
		FluidReplicatorBlockEntity blockEntity = (FluidReplicatorBlockEntity) be;
		if (!blockEntity.isShapeValid()) {
			return false;
		}
		final class_2338 hole = blockEntity.method_11016().method_10079(blockEntity.getFacing().method_10153(), 2);
		final class_3611 fluid = FluidUtils.fluidFromBlock(blockEntity.method_10997().method_8320(hole).method_26204());
		if (fluid == class_3612.field_15906) {
			return false;
		}
		if (!FluidUtils.fluidEquals(fluid, fluid().fluid())) {
			return false;
		}
		final class_3611 tankFluid = blockEntity.tank.getFluid();
		if (tankFluid != class_3612.field_15906 && !FluidUtils.fluidEquals(tankFluid, fluid)) {
			return false;
		}
		return blockEntity.tank.canFit(fluid().fluid(), fluid().getAmount());
	}

	@Override
	public boolean onCraft(class_2586 be) {
		FluidReplicatorBlockEntity blockEntity = (FluidReplicatorBlockEntity) be;
		FluidInstance fluid = fluid();
		if (blockEntity.tank.isEmpty()) {
			blockEntity.tank.setFluidInstance(fluid);
		} else if (blockEntity.tank.getFluid() == fluid.fluid()) {
			FluidValue amount = fluid.getAmount();
			if (blockEntity.tank.getFreeSpace().equalOrMoreThan(amount)) {
				blockEntity.tank.modifyFluid(value -> value.addAmount(amount));
			} else {
				return false;
			}
		}
		return true;
	}
}
