/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2024 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.recipe.recipes;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeDisplay;
import reborncore.common.crafting.SizedIngredient;
import techreborn.init.ModRecipes;
import techreborn.init.TRContent;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record FluidGeneratorRecipe(class_3956<? extends FluidGeneratorRecipe> type, int power, class_3611 fluid) implements RebornRecipe {
	public static Function<class_3956<FluidGeneratorRecipe>, MapCodec<FluidGeneratorRecipe>> CODEC = type -> RecordCodecBuilder.mapCodec(instance -> instance.group(
		class_5699.field_33442.fieldOf("power").forGetter(RebornRecipe::power),
		class_7923.field_41173.method_40294().fieldOf("fluid").forGetter(FluidGeneratorRecipe::fluidRegistryEntry)
	).apply(instance, (power, fluid) -> new FluidGeneratorRecipe(type, power, fluid)));
	public static Function<class_3956<FluidGeneratorRecipe>, class_9139<class_9129, FluidGeneratorRecipe>> PACKET_CODEC = type -> class_9139.method_56435(
		class_9135.field_49675, RebornRecipe::power,
		class_9135.method_56383(class_7924.field_41270), FluidGeneratorRecipe::fluidRegistryEntry,
		(power, fluid) -> new FluidGeneratorRecipe(type, power, fluid)
	);

	public FluidGeneratorRecipe(class_3956<? extends FluidGeneratorRecipe> type, int power, class_6880<class_3611> fluid) {
		this(type, power, fluid.comp_349());
	}

	@Override
	public List<SizedIngredient> ingredients() {
		return List.of();
	}

	@Override
	public List<class_1799> outputs() {
		return List.of();
	}

	@Override
	public int time() {
		return 0;
	}

	@Override
	public List<class_10295> method_64664() {
		final class_3956<?> type = method_17716();
		class_1799 stack = null;

		if (type == ModRecipes.THERMAL_GENERATOR) {
			stack = new class_1799(TRContent.Machine.THERMAL_GENERATOR);
		} else if (type == ModRecipes.GAS_GENERATOR) {
			stack = new class_1799(TRContent.Machine.GAS_TURBINE);
		} else if (type == ModRecipes.DIESEL_GENERATOR) {
			stack = new class_1799(TRContent.Machine.DIESEL_GENERATOR);
		} else if (type == ModRecipes.SEMI_FLUID_GENERATOR) {
			stack = new class_1799(TRContent.Machine.SEMI_FLUID_GENERATOR);
		} else if (type == ModRecipes.PLASMA_GENERATOR) {
			stack = new class_1799(TRContent.Machine.PLASMA_GENERATOR);
		}
		if (stack != null) {
			return List.of(new RebornRecipeDisplay(new class_10302.class_10307(stack)));
		}

		return RebornRecipe.super.method_64664();
	}

	public class_3611 getFluid() {
		return fluid;
	}

	public class_6880<class_3611> fluidRegistryEntry() {
		return getFluid().method_40178();
	}
}
