/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.recipe.recipes;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeDisplay;
import reborncore.common.crafting.SizedIngredient;
import techreborn.blockentity.machine.multiblock.IndustrialBlastFurnaceBlockEntity;
import techreborn.init.TRContent;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record BlastFurnaceRecipe(class_3956<? extends BlastFurnaceRecipe> type, List<SizedIngredient> ingredients, List<class_1799> outputs, int power, int time, int heat) implements RebornRecipe {
	public static Function<class_3956<BlastFurnaceRecipe>, MapCodec<BlastFurnaceRecipe>> CODEC = type -> RecordCodecBuilder.mapCodec(instance -> instance.group(
		Codec.list(SizedIngredient.CODEC.codec()).fieldOf("ingredients").forGetter(RebornRecipe::ingredients),
		Codec.list(class_1799.field_24671).fieldOf("outputs").forGetter(RebornRecipe::outputs),
		class_5699.field_33442.fieldOf("power").forGetter(RebornRecipe::power),
		class_5699.field_33442.fieldOf("time").forGetter(RebornRecipe::time),
		class_5699.field_33442.fieldOf("heat").forGetter(BlastFurnaceRecipe::getHeat)
	).apply(instance, (ingredients, outputs, power, time, heat) -> new BlastFurnaceRecipe(type, ingredients, outputs, power, time, heat)));
	public static Function<class_3956<BlastFurnaceRecipe>, class_9139<class_9129, BlastFurnaceRecipe>> PACKET_CODEC = type -> class_9139.method_56906(
		SizedIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()), RebornRecipe::ingredients,
		class_1799.field_48349.method_56433(class_9135.method_56363()), RebornRecipe::outputs,
		class_9135.field_49675, RebornRecipe::power,
		class_9135.field_49675, RebornRecipe::time,
		class_9135.field_49675, BlastFurnaceRecipe::getHeat,
		(ingredients, outputs, power, time, heat) -> new BlastFurnaceRecipe(type, ingredients, outputs, power, time, heat)
	);

	@Override
	public List<class_10295> method_64664() {
		class_1799 stack = new class_1799(TRContent.Machine.INDUSTRIAL_BLAST_FURNACE);
		return List.of(new RebornRecipeDisplay(new class_10302.class_10307(stack)));
	}

	public int getHeat() {
		return heat;
	}

	@Override
	public boolean canCraft(final class_2586 blockEntity) {
		if (blockEntity instanceof final IndustrialBlastFurnaceBlockEntity blastFurnace) {
			return blastFurnace.getHeat() >= heat;
		}
		return false;
	}

}
