/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.recipe;

import reborncore.common.crafting.RecipeUtils;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.RebornInventory;
import techreborn.init.ModRecipes;
import techreborn.recipe.recipes.ScrapBoxRecipe;

import java.util.List;
import net.minecraft.class_2586;

/**
 * @author drcrazy
 */
public class ScrapboxRecipeCrafter extends RecipeCrafter {
	private static List<ScrapBoxRecipe> RecipeListCache = null;

	/**
	 * @param parent      {@link class_2586} Tile having this crafter
	 * @param inventory   {@link RebornInventory} Inventory from parent blockEntity
	 * @param inputSlots  {@code int[]} Slot IDs for input
	 * @param outputSlots {@code int[]} Slot IDs for output
	 */
	public ScrapboxRecipeCrafter(class_2586 parent, RebornInventory<?> inventory, int[] inputSlots, int[] outputSlots) {
		super(ModRecipes.SCRAPBOX, parent, 1, 1, inventory, inputSlots, outputSlots);
	}

	@Override
	public void updateCurrentRecipe() {
		if(RecipeListCache == null){
			RecipeListCache = RecipeUtils.getRecipes(blockEntity.method_10997(), ModRecipes.SCRAPBOX);
		}
		List<ScrapBoxRecipe> scrapboxRecipeList = RecipeListCache;
		if (scrapboxRecipeList.isEmpty()) {
			setCurrentRecipe(null);
			return;
		}
		int random = blockEntity.method_10997().field_9229.method_43048(scrapboxRecipeList.size());
		// Sets the current recipe then syncs
		setCurrentRecipe(scrapboxRecipeList.get(random));
		this.currentNeededTicks = Math.max((int) (currentRecipe.time() * (1.0 - getSpeedMultiplier())), 1);
		this.currentTickTime = 0;
		setIsActive();
	}
}
