/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.recipe;

import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RecipeUtils;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModRecipes;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_5819;

public class RecyclerRecipeCrafter extends RecipeCrafter {

	public RecyclerRecipeCrafter(class_2586 blockEntity, RebornInventory<?> inventory, int[] inputSlots, int[] outputSlots) {
		super(ModRecipes.RECYCLER, blockEntity, 1, 1, inventory, inputSlots, outputSlots);
	}

	@Override
	public void updateCurrentRecipe() {
		currentTickTime = 0;
		List<RebornRecipe> recipeList = RecipeUtils.getRecipes(blockEntity.method_10997(), ModRecipes.RECYCLER);
		if (recipeList.isEmpty() || !hasAllInputs()) {
			setCurrentRecipe(null);
			currentNeededTicks = 0;
			setIsActive();
			return;
		}
		setCurrentRecipe(recipeList.get(0));
		currentNeededTicks = Math.max((int) (currentRecipe.time() * (1.0 - getSpeedMultiplier())), 1);
		setIsActive();
	}

	@Override
	public boolean hasAllInputs() {
		boolean hasItem = false;
		// Check if we have at least something in input slots. Foreach input slot in case of several input slots
		for (int inputSlot : inputSlots) {
			if (inventory.method_5438(inputSlot).method_7960()) continue;
			hasItem = true;
			break;
		}
		return hasItem;
	}

	@Override
	public void useAllInputs() {
		if (currentRecipe == null) {
			return;
		}
		// Uses input. Foreach input slot in case of several input slots
		for (int inputSlot : inputSlots) {
			if (inventory.method_5438(inputSlot).method_7960()) continue;
			inventory.shrinkSlot(inputSlot, 1);
			break;
		}
	}

	@Override
	public void fitStack(class_1799 stack, int slot) {
		final class_1937 world = Objects.requireNonNull(blockEntity.method_10997());
		final class_5819 random = world.field_9229;

		final int randomChance = random.method_43048(TechRebornConfig.recyclerChance);
		if (randomChance == 0) {
			super.fitStack(stack, slot);
		}
	}
}
