/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.tool.industrial;

import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import reborncore.api.IToolHandler;
import reborncore.common.powerSystem.RcEnergyItem;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.TorchHelper;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRContent;
import techreborn.init.TRItemSettings;
import techreborn.init.TRToolMaterials;


public class OmniToolItem extends class_1792 implements RcEnergyItem, IToolHandler {
	// 4M FE max charge with 1k charge rate
	public OmniToolItem(String name) {
		super(TRItemSettings.unbreakable(name).method_66331(TRToolMaterials.OMNI_TOOL, TRContent.BlockTags.OMNI_TOOL_MINEABLE, 3f, 1f, 0.0F));
	}

	// MiningToolItem
	@Override
	public boolean method_58405(class_1799 stack, class_2680 state) {
		return class_1802.field_8556.method_58405(stack, state) || class_1802.field_8802.method_58405(stack, state)
				|| class_1802.field_8377.method_58405(stack, state) || class_1802.field_8250.method_58405(stack, state)
				|| class_1802.field_8868.method_58405(stack, state);
	}

	@Override
	public float method_58404(class_1799 stack, class_2680 state) {
		if (getStoredEnergy(stack) >= TechRebornConfig.omniToolCost) {
			return TRToolMaterials.OMNI_TOOL.comp_2932();
		}
		class_9424 toolComponent = stack.method_58694(class_9334.field_50077);
		return toolComponent != null ? toolComponent.comp_2499() : 1.0F;
	}

	@Override
	public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 blockIn, class_2338 pos, class_1309 entityLiving) {
		tryUseEnergy(stack, TechRebornConfig.omniToolCost);
		return true;
	}

	@Override
	public void method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
		if (tryUseEnergy(stack, TechRebornConfig.omniToolHitCost) && target.method_73183() instanceof class_3218 serverWorld) {
			target.method_64397(serverWorld, serverWorld.method_48963().method_48802((class_1657) attacker), 8F);
		}
	}

	// Item
	@Override
	public class_1269 method_7884(class_1838 context) {
		class_1269 tryUse = class_1802.field_8556.method_7884(context);
		if (tryUse != class_1269.field_5811) { return tryUse; }

		tryUse = class_1802.field_8868.method_7884(context);
		if (tryUse != class_1269.field_5811) { return tryUse; }

		tryUse = class_1802.field_8250.method_7884(context);
		if (tryUse != class_1269.field_5811) { return tryUse; }

		return TorchHelper.placeTorch(context);
	}

	@Override
	public int method_31569(class_1799 stack) {
		return ItemUtils.getPowerForDurabilityBar(stack);
	}

	@Override
	public boolean method_31567(class_1799 stack) {
		return true;
	}

	@Override
	public int method_31571(class_1799 stack) {
		return ItemUtils.getColorForDurabilityBar(stack);
	}

	// RcEnergyItem
	@Override
	public long getEnergyCapacity(class_1799 stack) {
		return TechRebornConfig.omniToolCharge;
	}

	@Override
	public long getEnergyMaxOutput(class_1799 stack) {
		return 0;
	}

	@Override
	public RcEnergyTier getTier() {
		return RcEnergyTier.EXTREME;
	}

	// IToolHandler
	@Override
	public boolean handleTool(class_1799 stack, class_2338 pos, class_1937 world, class_1657 player, class_2350 side, boolean damage) {
		if (!player.method_73183().method_8608() && this.getStoredEnergy(stack) >= 5.0) {
			this.tryUseEnergy(stack, 5);
			return true;
		} else {
			return false;
		}
	}

}
