/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.tool.industrial;

import org.jetbrains.annotations.Nullable;
import reborncore.common.powerSystem.RcEnergyItem;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.ItemUtils;
import techreborn.component.TRDataComponentTypes;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRItemSettings;
import techreborn.init.TRToolMaterials;
import techreborn.utils.TRItemUtils;

import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public class NanosaberItem extends class_1792 implements RcEnergyItem {
	private static final class_1322 ENABLED_ATTACK_DAMAGE_MODIFIER = new class_1322(class_2960.method_60655("techreborn", "nano_saber_attack_damage"), TechRebornConfig.nanosaberDamage, class_1322.class_1323.field_6328);
	private static final class_1322 ENABLED_ATTACK_SPEED_MODIFIER = new class_1322(class_2960.method_60655("techreborn", "nano_saber_attack_speed"), 3, class_1322.class_1323.field_6328);
	private static final class_1322 DISABLED_ATTACK_DAMAGE_MODIFIER = new class_1322(class_2960.method_60655("techreborn", "nano_saber_attack_damage"), 0, class_1322.class_1323.field_6328);
	private static final class_1322 DISABLED_ATTACK_SPEED_MODIFIER = new class_1322(class_2960.method_60655("techreborn", "nano_saber_attack_speed"), 0, class_1322.class_1323.field_6328);

	// 1ME max charge with 2k charge rate
	public NanosaberItem(String name) {
		super(TRItemSettings.unbreakable(name).method_66333(TRToolMaterials.NANOSABER, 1f, 1f));
	}

	// SwordItem
	@Override
	public void method_7873(class_1799 stack, class_1309 entityHit, class_1309 entityHitter) {
		tryUseEnergy(stack, TechRebornConfig.nanosaberCost);
	}

	// Item
	@Override
	public void method_7888(class_1799 stack, class_3218 worldIn, class_1297 entityIn, @Nullable class_1304 slot) {
		TRItemUtils.checkActive(stack, TechRebornConfig.nanosaberCost, entityIn);

		boolean isActive = stack.method_58694(TRDataComponentTypes.IS_ACTIVE) == Boolean.TRUE;
		class_9285 attributes = stack.method_58695(class_9334.field_49636, class_9285.field_49326);
		attributes = attributes.method_57484(class_5134.field_23721, isActive ? ENABLED_ATTACK_DAMAGE_MODIFIER : DISABLED_ATTACK_DAMAGE_MODIFIER, class_9274.field_49217)
			.method_57484(class_5134.field_23723, isActive ? ENABLED_ATTACK_SPEED_MODIFIER : DISABLED_ATTACK_SPEED_MODIFIER, class_9274.field_49217);
		stack.method_57379(class_9334.field_49636, attributes);
	}

	@Override
	public class_1269 method_7836(final class_1937 world, final class_1657 player, final class_1268 hand) {
		final class_1799 stack = player.method_5998(hand);
		if (player.method_5715()) {
			TRItemUtils.switchActive(stack, TechRebornConfig.nanosaberCost, player);
			return class_1269.field_5812;
		}
		return class_1269.field_5811;
	}

	@Override
	public void method_67187(class_1799 stack, class_9635 context, class_10712 displayComponent, Consumer<class_2561> tooltip, class_1836 type) {
		TRItemUtils.buildActiveTooltip(stack, tooltip);
	}

	@Override
	public int method_31569(class_1799 stack) {
		return ItemUtils.getPowerForDurabilityBar(stack);
	}

	@Override
	public boolean method_31567(class_1799 stack) {
		return true;
	}

	@Override
	public int method_31571(class_1799 stack) {
		return ItemUtils.getColorForDurabilityBar(stack);
	}

	// RcEnergyItem
	@Override
	public long getEnergyCapacity(class_1799 stack) {
		return TechRebornConfig.nanosaberCharge;
	}

	@Override
	public RcEnergyTier getTier() {
		return RcEnergyTier.EXTREME;
	}

	@Override
	public long getEnergyMaxOutput(class_1799 stack) {
		return 0;
	}

}
