/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.tool.industrial;

import reborncore.common.powerSystem.RcEnergyTier;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRToolMaterials;
import techreborn.items.tool.DrillItem;
import techreborn.utils.TRItemUtils;
import techreborn.utils.ToolsUtil;

import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

public class IndustrialDrillItem extends DrillItem {

	public IndustrialDrillItem(String name) {
		super(TRToolMaterials.INDUSTRIAL_DRILL, TechRebornConfig.industrialDrillCharge, RcEnergyTier.INSANE, TechRebornConfig.industrialDrillCost, 20.0F, name);
	}

	private boolean shouldBreak(class_1657 playerIn, class_1937 worldIn, class_2338 originalPos, class_2338 pos) {
		if (originalPos.equals(pos)) {
			return false;
		}
		class_2680 blockState = worldIn.method_8320(pos);
		if (blockState.method_26215()) {
			return false;
		}
		if (blockState.method_51176()) {
			return false;
		}
		float blockHardness = blockState.method_26165(playerIn, worldIn, pos);
		if (blockHardness == -1.0F) {
			return false;
		}
		float originalHardness = worldIn.method_8320(originalPos).method_26214(worldIn, originalPos);
		return !((originalHardness / blockHardness) > 10.0F);
	}

	// DrillItem
	@Override
	public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 stateIn, class_2338 pos, class_1309 entityLiving) {
		if (!TRItemUtils.isActive(stack)) {
			return super.method_7879(stack, worldIn, stateIn, pos, entityLiving);
		}
		if (!(entityLiving instanceof class_1657 playerIn)) {
			return super.method_7879(stack, worldIn, stateIn, pos, entityLiving);
		}
		for (class_2338 additionalPos : ToolsUtil.getAOEMiningBlocks(worldIn, pos, entityLiving, 1)) {
			if (shouldBreak(playerIn, worldIn, pos, additionalPos)) {
				ToolsUtil.breakBlock(stack, worldIn, additionalPos, entityLiving, cost);
			}
		}

		return super.method_7879(stack, worldIn, stateIn, pos, entityLiving);
	}

	// Item
	@Override
	public class_1269 method_7836(final class_1937 world, final class_1657 player, final class_1268 hand) {
		final class_1799 stack = player.method_5998(hand);
		if (player.method_5715()) {
			TRItemUtils.switchActive(stack, cost, player);
			return class_1269.field_5812;
		}
		return class_1269.field_5811;
	}

	@Override
	public void method_7852(class_1937 world, class_1309 entity, class_1799 stack, int i) {
		TRItemUtils.checkActive(stack, cost, entity);
	}

	@Override
	public void method_67187(class_1799 stack, class_9635 context, class_10712 displayComponent, Consumer<class_2561> tooltip, class_1836 type) {
		TRItemUtils.buildActiveTooltip(stack, tooltip);
	}
}
