/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.tool.industrial;

import reborncore.common.powerSystem.RcEnergyTier;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRToolMaterials;
import techreborn.items.tool.ChainsawItem;
import techreborn.utils.TRItemUtils;
import techreborn.utils.ToolsUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3481;

public class IndustrialChainsawItem extends ChainsawItem {

	private static final class_2350[] SEARCH_ORDER = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039, class_2350.field_11036};

	private class_2680 lastCheckedBlockState;

	public IndustrialChainsawItem(String name) {
		super(TRToolMaterials.INDUSTRIAL_CHAINSAW, TechRebornConfig.industrialChainsawCharge, RcEnergyTier.INSANE, TechRebornConfig.industrialChainsawCost, 20F, name);
	}

	private boolean isValidLog(class_2680 state) {
		return state.method_26164(class_3481.field_15475);
	}

	private boolean isValidLeaves(class_2680 state) {
		return state.method_26164(class_3481.field_15503) || state.method_26164(class_3481.field_21954) || state.method_27852(class_2246.field_22122);
	}

	private boolean isValidStartBlock(class_2680 state) {
		return isValidLog(state) || isValidLeaves(state);
	}

	private void findWood(class_1937 world, class_2338 pos, List<class_2338> wood, List<class_2338> leaves) {
		//Limit the amount of wood to be broken to 64 blocks.
		if (wood.size() >= 64) {
			return;
		}
		//Search 150 leaves for wood
		if (leaves.size() >= 150) {
			return;
		}
		for (class_2350 facing : SEARCH_ORDER) {
			class_2338 checkPos = pos.method_10093(facing);
			if (!wood.contains(checkPos) && !leaves.contains(checkPos)) {
				class_2680 state = world.method_8320(checkPos);

				if (isValidLog(state)) {
					wood.add(checkPos);
					findWood(world, checkPos, wood, leaves);
				} else if (isValidLeaves(state)) {
					leaves.add(checkPos);
					findWood(world, checkPos, wood, leaves);
				}
			}
		}
	}

	//ChainsawItem
	@Override
	public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 blockIn, class_2338 pos, class_1309 entityLiving) {
		List<class_2338> wood = new ArrayList<>();
		List<class_2338> leaves = new ArrayList<>();
		if (TRItemUtils.isActive(stack) && (lastCheckedBlockState == null || isValidStartBlock(lastCheckedBlockState))) {
			findWood(worldIn, pos, wood, leaves);
			wood.remove(pos);
			wood.stream()
					.filter(p -> tryUseEnergy(stack, cost))
					.forEach(pos1 -> ToolsUtil.breakBlock(stack, worldIn, pos1, entityLiving, cost));
			leaves.remove(pos);
			leaves.forEach(pos1 -> ToolsUtil.breakBlock(stack, worldIn, pos1, entityLiving, 0));
		}
		return super.method_7879(stack, worldIn, blockIn, pos, entityLiving);
	}

	// Item
	@Override
	public boolean method_7885(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1309 miner) {
		lastCheckedBlockState = state;
		return super.method_7885(stack, state, world, pos, miner);
	}

	@Override
	public class_1269 method_7836(final class_1937 world, final class_1657 player, final class_1268 hand) {
		final class_1799 stack = player.method_5998(hand);
		if (player.method_5715()) {
			TRItemUtils.switchActive(stack, cost, player);
			return class_1269.field_5812;
		}
		return class_1269.field_5811;
	}

	@Override
	public void method_7852(class_1937 world, class_1309 entity, class_1799 stack, int i) {
		TRItemUtils.checkActive(stack, cost, entity);
	}

	@Override
	public void method_67187(class_1799 stack, class_9635 context, class_10712 displayComponent, Consumer<class_2561> tooltip, class_1836 type) {
		TRItemUtils.buildActiveTooltip(stack, tooltip);
	}
}
