/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.tool.basic;

import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import reborncore.common.powerSystem.RcEnergyItem;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.ItemUtils;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRItemSettings;
import techreborn.init.TRToolMaterials;

public class RockCutterItem extends class_1792 implements RcEnergyItem {
	// 10k Energy with 128 E\t charge rate
	public RockCutterItem(String name) {
		// combat stats same as for diamond pickaxe. Fix for #2468
		super(TRItemSettings.unbreakable(name).method_66330(TRToolMaterials.ROCK_CUTTER,  1f, -2.8f));
	}

	// PickaxeItem
	@Override
	public boolean method_58405(class_1799 stack, class_2680 state) {
		return class_1802.field_8377.method_58405(stack, state);
	}

	@Override
	public float method_58404(class_1799 stack, class_2680 state) {
		if (getStoredEnergy(stack) < TechRebornConfig.rockCutterCost) {
			return 1.0f;
		} else {
			return class_1802.field_8377.method_58404(stack, state);
		}
	}

	// MiningToolItem
	@Override
	public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 blockIn, class_2338 pos, class_1309 entityLiving) {
		tryUseEnergy(stack, TechRebornConfig.rockCutterCost);
		return true;
	}

	// Item
	@Override
	public void method_7843(class_1799 stack, class_1937 world) {
		if (!stack.method_7942()) {
			class_7225.class_7226<class_1887> registry = world.method_30349().method_30530(class_7924.field_41265);
			stack.method_7978(registry.method_46747(class_1893.field_9099), 1);
		}

		super.method_7843(stack, world);
	}

	@Override
	public int method_31569(class_1799 stack) {
		return ItemUtils.getPowerForDurabilityBar(stack);
	}

	@Override
	public boolean method_31567(class_1799 stack) {
		return true;
	}

	@Override
	public int method_31571(class_1799 stack) {
		return ItemUtils.getColorForDurabilityBar(stack);
	}

	// RcEnergyItem
	@Override
	public long getEnergyCapacity(class_1799 stack) {
		return TechRebornConfig.rockCutterCharge;
	}

	@Override
	public RcEnergyTier getTier() {
		return RcEnergyTier.MEDIUM;
	}

	@Override
	public long getEnergyMaxOutput(class_1799 stack) {
		return 0;
	}

}
