/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.tool;

import techreborn.blockentity.cable.CableBlockEntity;
import techreborn.blocks.cable.CableBlock;
import techreborn.component.TRDataComponentTypes;
import techreborn.init.TRContent;
import techreborn.init.TRItemSettings;

import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class PaintingToolItem extends class_1792 {

	public PaintingToolItem(String name) {
		super(TRItemSettings.item(name).method_7895(64));
	}

	public class_1269 method_7884(class_1838 context) {
		class_1657 player = context.method_8036();
		if (player == null) {
			return class_1269.field_5814;
		}

		class_2680 blockState = context.method_8045().method_8320(context.method_8037());
		if (player.method_5715()) {
			boolean opaqueFullCube = blockState.method_26216()
				&& blockState.method_26204().method_9564().method_26216();

			if (opaqueFullCube || blockState.method_26164(TRContent.BlockTags.NONE_SOLID_COVERS)) {
				context.method_8041().method_57379(TRDataComponentTypes.PAINTING_COVER, blockState);
				context.method_8041().method_57379(TRDataComponentTypes.PAINTING_COVER, blockState);
				return class_1269.field_5812;
			}
			return class_1269.field_5814;
		} else {
			class_2680 cover = getCover(context.method_8041());
			if (cover != null && blockState.method_26204() instanceof CableBlock && blockState.method_11654(CableBlock.COVERED)) {
				class_2586 blockEntity = context.method_8045().method_8321(context.method_8037());
				if (blockEntity == null) {
					return class_1269.field_5814;
				}
				((CableBlockEntity) blockEntity).setCover(cover);

				context.method_8045().method_8396(player, context.method_8037(), class_3417.field_15226, class_3419.field_15245, 0.6F, 1.0F);
				if (!context.method_8045().method_8608()) {
					context.method_8041().method_7970(1, player, context.method_20287() == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
				}

				return class_1269.field_5812;
			}
		}

		return class_1269.field_5814;
	}

	public static class_2680 getCover(class_1799 stack) {
		return stack.method_58695(TRDataComponentTypes.PAINTING_COVER, null);
	}

	@Override
	public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> tooltip, class_1836 type) {
		class_2680 blockState = getCover(stack);
		if (blockState != null) {
			tooltip.accept((class_2561.method_43471(blockState.method_26204().method_63499())).method_27692(class_124.field_1080));
			tooltip.accept((class_2561.method_43471("techreborn.tooltip.painting_tool.apply")).method_27692(class_124.field_1065));
		} else {
			tooltip.accept((class_2561.method_43471("techreborn.tooltip.painting_tool.select")).method_27692(class_124.field_1065));
		}
	}

}
