/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.tool;

import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_9886;
import reborncore.common.powerSystem.RcEnergyItem;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.ItemUtils;
import techreborn.init.TRContent;
import techreborn.init.TRItemSettings;


public class JackhammerItem extends class_1792 implements RcEnergyItem {
	public final int maxCharge;
	public final RcEnergyTier tier;
	public final int cost;
	protected final float unpoweredSpeed = 0.5F;

	public JackhammerItem(class_9886 material, int energyCapacity, RcEnergyTier tier, int cost, String name) {
		super(TRItemSettings.unbreakable(name).method_66330(material, -2f, -2.8f));
		this.maxCharge = energyCapacity;
		this.tier = tier;
		this.cost = cost;
	}

	/**
	 * Checks if block in additional BlockPos should be broken. Used for AOE mining.
	 *
	 * @param worldIn     World reference
	 * @param originalPos Original mined block
	 * @param pos         Additional block to check
	 * @return Returns true if block should be broken by AOE mining
	 */
	protected boolean shouldBreak(class_1937 worldIn, class_2338 originalPos, class_2338 pos) {
		if (originalPos.equals(pos)) {
			return false;
		}
		return worldIn.method_8320(pos).method_26164(TRContent.BlockTags.JACKHAMMER_MINEABLE);
	}

	// Item
	@Override
	public float method_58404(class_1799 stack, class_2680 state) {
		if (getStoredEnergy(stack) >= cost && state.method_26164(TRContent.BlockTags.JACKHAMMER_MINEABLE)) {
			return super.method_58404(stack, state);
		}
		return unpoweredSpeed;
	}

	@Override
	public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 blockIn, class_2338 pos, class_1309 entityLiving) {
		tryUseEnergy(stack, cost);
		return true;
	}

	@Override
	public int method_31569(class_1799 stack) {
		return ItemUtils.getPowerForDurabilityBar(stack);
	}

	@Override
	public boolean method_31567(class_1799 stack) {
		return true;
	}

	@Override
	public int method_31571(class_1799 stack) {
		return ItemUtils.getColorForDurabilityBar(stack);
	}

	// RcEnergyItem
	@Override
	public long getEnergyCapacity(class_1799 stack) {
		return maxCharge;
	}

	@Override
	public RcEnergyTier getTier() {
		return tier;
	}

	@Override
	public long getEnergyMaxOutput(class_1799 stack) {
		return 0;
	}

}
