/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.tool;

import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_9886;
import reborncore.common.powerSystem.RcEnergyItem;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.ItemUtils;
import techreborn.init.TRContent;
import techreborn.init.TRItemSettings;

public class DrillItem extends class_1792 implements RcEnergyItem {
	public final int maxCharge;
	public final RcEnergyTier tier;
	public final int cost;
	public final float poweredSpeed;
	protected final float unpoweredSpeed = 0.5f;


	public DrillItem(class_9886 material, int energyCapacity, RcEnergyTier tier, int cost, float poweredSpeed, String name) {
		super(TRItemSettings.unbreakable(name).method_66331(material, TRContent.BlockTags.DRILL_MINEABLE, -2f, -2.8f, 0.0F));
		this.maxCharge = energyCapacity;
		this.tier = tier;
		this.cost = cost;
		this.poweredSpeed = poweredSpeed;
	}

	//Item
	@Override
	public float method_58404(class_1799 stack, class_2680 state) {
		if (getStoredEnergy(stack) >= cost && method_58405(stack, state)) {
			return poweredSpeed;
		}
		return unpoweredSpeed;
	}

	@Override
	public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 blockIn, class_2338 pos, class_1309 entityLiving) {
		tryUseEnergy(stack, cost);
		return true;
	}

	@Override
	public int method_31569(class_1799 stack) {
		return ItemUtils.getPowerForDurabilityBar(stack);
	}

	@Override
	public boolean method_31567(class_1799 stack) {
		return true;
	}

	@Override
	public int method_31571(class_1799 stack) {
		return ItemUtils.getColorForDurabilityBar(stack);
	}

	// RcEnergyItem
	@Override
	public long getEnergyCapacity(class_1799 stack) {
		return maxCharge;
	}

	@Override
	public RcEnergyTier getTier() {
		return tier;
	}

	@Override
	public long getEnergyMaxOutput(class_1799 stack) {
		return 0;
	}
}
