/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.tool;

import reborncore.common.powerSystem.PowerSystem;
import team.reborn.energy.api.EnergyStorage;
import techreborn.init.TRItemSettings;

import java.util.Map.Entry;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3161;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

/**
 * Created by Mark on 20/03/2016.
 */
public class DebugToolItem extends class_1792 {

	public DebugToolItem(String name) {
		super(TRItemSettings.item(name));
	}

	@Override
	public class_1269 method_7884(class_1838 context) {
		class_2680 blockState = context.method_8045().method_8320(context.method_8037());
		class_2248 block = blockState.method_26204();
		if (block == null) {
			return class_1269.field_5814;
		}
		if (context.method_8045().method_8608()) {
			return class_1269.field_5812;
		}
		sendMessage(context, class_2561.method_43470(getRegistryName(block)));

		for (Entry<class_2769<?>, Comparable<?>> entry : blockState.method_11656().entrySet()) {
			sendMessage(context, class_2561.method_43470(getPropertyString(entry)));
		}

		EnergyStorage energyStorage = EnergyStorage.SIDED.find(context.method_8045(), context.method_8037(), context.method_8038());
		if (energyStorage != null) {
			sendMessage(context, class_2561.method_43470(getRCPower(energyStorage)));
		}

		class_2586 blockEntity = context.method_8045().method_8321(context.method_8037());
		if (blockEntity == null) {
			return class_1269.field_21466;
		}

		sendMessage(context, class_2561.method_43470(getBlockEntityType(blockEntity)));

		sendMessage(context, getBlockEntityTags(blockEntity));

		return class_1269.field_21466;
	}

	private void sendMessage(class_1838 context, class_2561 message) {
		if (context.method_8045().method_8608() || context.method_8036() == null) {
			return;
		}
		context.method_8036().method_7353(message, false); // TODO check if this is correct boolean
	}

	private String getPropertyString(Entry<class_2769<?>, Comparable<?>> entryIn) {
		class_2769<?> property = entryIn.getKey();
		Comparable<?> comparable = entryIn.getValue();
		String s = class_156.method_650(property, comparable);
		if (Boolean.TRUE.equals(comparable)) {
			s = class_124.field_1060 + s;
		} else if (Boolean.FALSE.equals(comparable)) {
			s = class_124.field_1061 + s;
		}

		return property.method_11899() + ": " + s;
	}

	private String getRegistryName(class_2248 block) {
		String s = "" + class_124.field_1060;
		s += "Block Registry Name: ";
		s += class_124.field_1078;
		s += class_7923.field_41175.method_10221(block);

		return s;
	}

	private String getBlockEntityType(class_2586 blockEntity) {
		String s = "" + class_124.field_1060;
		s += "Block Entity: ";
		s += class_124.field_1078;
		s += blockEntity.method_11017().toString();

		return s;
	}

	private String getRCPower(EnergyStorage energyStorage) {
		String s = "" + class_124.field_1060;
		s += "Power: ";
		s += class_124.field_1078;
		s += PowerSystem.getLocalizedPower(energyStorage.getAmount());
		s += "/";
		s += PowerSystem.getLocalizedPower(energyStorage.getCapacity());

		return s;
	}

	private class_2561 getBlockEntityTags(class_2586 blockEntity){
		class_5250 s = class_2561.method_43470("BlockEntity Tags:").method_27692(class_124.field_1060);

		class_3161 bdo = new class_3161(blockEntity, blockEntity.method_11016());
		s.method_27693(bdo.method_13881().toString());

		return s;
	}
}
