/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2025 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.armor;

import net.minecraft.class_1656;
import net.minecraft.class_1657;

public class VanillaQuantumSuitFlightHandler extends QuantumSuitFlightHandler {
	@Override
	public void setAllowFlight(class_1657 playerEntity, boolean allowed) {
		final class_1656 abilities = playerEntity.method_31549();
		final boolean requiresChanges = abilities.field_7478 != allowed || (!allowed && abilities.field_7479);

		if (!requiresChanges) {
			return;
		}

		abilities.field_7478 = allowed;

		if (!allowed) {
			abilities.field_7479 = false;
		}

		playerEntity.method_7355();
	}

	@Override
	public boolean isFlying(class_1657 playerEntity) {
		return playerEntity.method_31549().field_7479;
	}
}
