/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.armor;

import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_8051;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import reborncore.common.powerSystem.RcEnergyItem;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.ItemUtils;
import techreborn.init.TRItemSettings;

public abstract class TREnergyArmourItem extends class_1792 implements RcEnergyItem {
	public final long maxCharge;
	private final RcEnergyTier energyTier;

	public TREnergyArmourItem(class_1741 material, class_8051 slot, long maxCharge, RcEnergyTier energyTier, String name) {
		super(TRItemSettings.unbreakable(name).method_7889(1).method_66332(material, slot));
		this.maxCharge = maxCharge;
		this.energyTier = energyTier;
	}

	// Item
	@Override
	public int method_31569(class_1799 stack) {
		return ItemUtils.getPowerForDurabilityBar(stack);
	}

	@Override
	public boolean method_31567(class_1799 stack) {
		return true;
	}

	@Override
	public int method_31571(class_1799 stack) {
		return ItemUtils.getColorForDurabilityBar(stack);
	}

	// RcEnergyItem
	@Override
	public long getEnergyCapacity(class_1799 stack) {
		return maxCharge;
	}

	@Override
	public RcEnergyTier getTier() {
		return energyTier;
	}

	@Nullable
	public class_1304 getSlotType() {
		class_10192 equippableComponent = this.method_57347().method_58694(class_9334.field_54196);
		return equippableComponent != null ? equippableComponent.comp_3174() : null;
	}
}
