/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.armor;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_8051;
import reborncore.api.items.ArmorBlockEntityTicker;
import reborncore.api.items.ArmorRemoveHandler;
import reborncore.common.powerSystem.RcEnergyTier;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRArmorMaterials;

public class CloakingDeviceItem extends TREnergyArmourItem implements ArmorBlockEntityTicker, ArmorRemoveHandler {
	// 40M FE capacity with 8k FE\t charge rate
	public CloakingDeviceItem(String name) {
		super(TRArmorMaterials.CLOAKING_DEVICE, class_8051.field_41935, TechRebornConfig.cloakingDeviceCharge, RcEnergyTier.INSANE, name);
	}

	// TREnergyArmourItem
	@Override
	public long getEnergyMaxOutput(class_1799 stack) { return 0; }

	// ArmorBlockEntityTicker
	@Override
	public void tickArmor(class_1799 stack, boolean hasFullSuit, class_1657 playerEntity) {
		if (tryUseEnergy(stack, TechRebornConfig.cloakingDeviceCost)) {
			playerEntity.method_5648(true);
		} else {
			if (playerEntity.method_5767()) {
				playerEntity.method_5648(false);
			}
		}
	}

	// ArmorRemoveHandler
	@Override
	public void onRemoved(class_1657 playerEntity) {
		if (playerEntity.method_5767()) {
			playerEntity.method_5648(false);
		}
	}
}
