/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2025 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.armor;

import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_6880;
import net.minecraft.class_8051;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

import static techreborn.TechReborn.MOD_ID;

public class AttributeModifierBuilder {
	public static final class_10712 ATTRIBUTE_HIDE = new class_10712(
		false,
		new LinkedHashSet<>(Set.of(class_9334.field_49630, class_9334.field_49636))
	);
	private final class_9285.class_9286 builder;
	private final class_9274 target;

	public AttributeModifierBuilder() {
		this(null);
	}

	public AttributeModifierBuilder(@Nullable class_8051 slot) {
		builder = class_9285.method_57480();
		target = slot == null ? null : class_9274.method_59524(slot.method_48399());
	}

	private class_1322 modifier(String path, double value) {
		class_2960 id = class_2960.method_60655(MOD_ID, (target == null ? path : path + "/" + target.method_15434()));
		return new class_1322(id, value, class_1322.class_1323.field_6328);
	}

	public AttributeModifierBuilder armor(int i) {
		builder.method_57487(class_5134.field_23724, modifier("suit_armor", i), target);
		return this;
	}

	public AttributeModifierBuilder toughness(int i) {
		builder.method_57487(class_5134.field_23725, modifier("suit_armor_toughness", i), target);
		return this;
	}

	public AttributeModifierBuilder knockback(double i) {
		builder.method_57487(class_5134.field_23718, modifier("suit_knockback_resistance", i / 10), target);
		return this;
	}

	public class_9285 build() {
		return builder.method_57486();
	}

	public static boolean equals(@Nullable class_9285 attributes, class_9285 target) {
		if (attributes == null) {
			return false;
		}
		List<class_9285.class_9287> m1 = attributes.comp_2393();
		List<class_9285.class_9287> m2 = target.comp_2393();
		if (m1.size() < m2.size()) {
			return false;
		}
		Map<class_2960, Double> map = new HashMap<>();
		m1.forEach(entry -> map.put(entry.comp_2396().comp_2447(), entry.comp_2396().comp_2449()));
		for (class_9285.class_9287 entry : m2) {
			if (map.get(entry.comp_2396().comp_2447()) != entry.comp_2396().comp_2449()) {
				return false;
			}
		}
		return true;
	}

	public static void appendText(List<class_2561> tooltip, class_9285 attributes, class_124 formatting) {
		attributes.comp_2393().forEach(entry -> {
			tooltip.add(AttributeModifierBuilder.text(entry.comp_2395(), entry.comp_2396(), entry.comp_2396().comp_2449()).method_27692(formatting));
		});
	}

	public static void appendEnchantmentText(List<class_2561> tooltip, class_1799 stack, class_1304 slotType, class_124 formatting) {
		class_1890.method_60622(
			stack, class_9274.method_59524(slotType), (entry, modifier) -> {
				tooltip.add(AttributeModifierBuilder.text(entry, modifier, modifier.comp_2449()).method_27692(formatting));
			}
		);
	}

	public static void appendArmorEnchantmentText(List<class_2561> tooltip, class_1799 stack, class_124 formatting) {
		MutableBoolean mutableBoolean = new MutableBoolean(true);
		class_1890.method_60622(
			stack, class_9274.field_49224, (entry, modifier) -> {
				if (mutableBoolean.isTrue()) {
					tooltip.add(class_5244.field_39003);
					tooltip.add(class_2561.method_43471("item.modifiers.armor").method_27692(class_124.field_1080));
					mutableBoolean.setFalse();
				}
				tooltip.add(AttributeModifierBuilder.text(entry, modifier, modifier.comp_2449()).method_27692(formatting));
			}
		);
	}

	public static void appendDiffText(
		List<class_2561> tooltip,
		@Nullable class_9285 attributes,
		class_9285 target,
		class_124 formatting
	) {
		Map<class_2960, Double> map = new HashMap<>();
		if (attributes != null) {
			attributes.comp_2393().forEach(entry -> map.put(entry.comp_2396().comp_2447(), entry.comp_2396().comp_2449()));
		}
		target.comp_2393().forEach(entry -> {
			double value = entry.comp_2396().comp_2449() - map.getOrDefault(entry.comp_2396().comp_2447(), 0d);
			if (value != 0) {
				tooltip.add(AttributeModifierBuilder.text(entry.comp_2395(), entry.comp_2396(), value).method_27692(formatting));
			}
		});
	}

	public static void appendEnd(List<class_2561> tooltip, List<class_2561> buffer) {
		class_5251 skip = class_5251.method_27718(class_124.field_1063);
		for (int i = tooltip.size() - 1; i >= 0; i--) {
			if (tooltip.get(i).method_10866().method_10973() != skip) {
				tooltip.addAll(i + 1, buffer);
				break;
			}
		}
	}

	private static class_5250 text(class_6880<class_1320> attribute, class_1322 modifier, double value) {
		class_1322.class_1323 operation = modifier.comp_2450();
		if (operation == class_1322.class_1323.field_6330 || operation == class_1322.class_1323.field_6331) {
			value = value * 100.0;
		} else if (class_5134.field_23718.method_40225(attribute.method_40230().orElseThrow())) {
			value *= 10;
		}
		return class_2561.method_43469(
			(value > 0 ? "attribute.modifier.plus." : "attribute.modifier.take.") + operation.method_56082(),
			class_9285.field_49329.format(value > 0 ? value : -value),
			class_2561.method_43471(attribute.comp_349().method_26830())
		);
	}

	public static class_5250 text(class_1304 slotType) {
		return class_2561.method_43471("item.modifiers." + class_9274.method_59524(slotType).method_15434());
	}
}
