/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2022 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items;

import reborncore.common.blockentity.MachineBaseBlockEntity;
import techreborn.blockentity.storage.fluid.TankUnitBaseBlockEntity;
import techreborn.blockentity.storage.item.StorageUnitBaseBlockEntity;
import techreborn.init.TRContent.StorageUnit;
import techreborn.init.TRContent.TankUnit;
import techreborn.init.TRItemSettings;

import static techreborn.TechReborn.LOGGER;

import net.minecraft.class_11352;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_8942;

public class UpgraderItem extends class_1792 {

	public UpgraderItem(String name) {
		super(TRItemSettings.item(name));
	}

	@Override
	public class_1269 method_7884(class_1838 context) {
		class_1937 world = context.method_8045();
		class_2338 blockPos = context.method_8037();
		class_2586 oldBlockEntity = world.method_8321(blockPos);
		if (oldBlockEntity == null){
			return class_1269.field_5811;
		}
		if (!(oldBlockEntity instanceof StorageUnitBaseBlockEntity) && !(oldBlockEntity instanceof TankUnitBaseBlockEntity)){
			return class_1269.field_5811;
		}
		class_2680 oldBlockState = world.method_8320(blockPos);
		class_2680 newBlockState = null;
		String newType = "";
		// if no storage upgrader, the isOf compares with null and returns false
		if (oldBlockState.method_27852(StorageUnit.getUpgradableFor(this).map(StorageUnit::asBlock).orElse(null))) {
			// upgradable is now guaranteed to be present, or something is seriously wrong
			// we want to get the next unit in the enum, hence ordinal()+1
			newBlockState = StorageUnit.values()[StorageUnit.getUpgradableFor(this).orElseThrow().ordinal()+1].asBlock().method_34725(oldBlockState);
			newType = StorageUnit.values()[StorageUnit.getUpgradableFor(this).orElseThrow().ordinal()+1].name();
		}
		// same for the tank
		else if (oldBlockState.method_27852(TankUnit.getUpgradableFor(this).map(TankUnit::asBlock).orElse(null))) {
			newBlockState = TankUnit.values()[TankUnit.getUpgradableFor(this).orElseThrow().ordinal()+1].asBlock().method_9564();
			newType = TankUnit.values()[TankUnit.getUpgradableFor(this).orElseThrow().ordinal()+1].name();
		}
		if (newBlockState == null) {
			return class_1269.field_5811;
		}

		class_2487 data = oldBlockEntity.method_38244(world.method_30349());
		data.method_10582("unitType", newType);

		try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "UpgraderItem", LOGGER)) {
			// empty storage to prevent item spill
			oldBlockEntity.method_58690(class_11352.method_71417(logging, world.method_30349(), new class_2487()));

			world.method_8501(blockPos, newBlockState);

			// restore content and set a new storage type
			class_2586 newBlockEntity = world.method_8321(blockPos);
			if (newBlockEntity != null){
				newBlockEntity.method_58690(class_11352.method_71417(logging, world.method_30349(), data));
				((MachineBaseBlockEntity) newBlockEntity).syncWithAll();
			}
		}

		class_1799 stack = context.method_8041();
		stack.method_7934(1);

		return class_1269.field_5812;
	}
}
