/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items;

import reborncore.common.crafting.RecipeUtils;
import reborncore.common.util.WorldUtils;
import techreborn.init.ModRecipes;
import techreborn.init.TRContent;
import techreborn.init.TRItemSettings;
import techreborn.recipe.recipes.ScrapBoxRecipe;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class ScrapBoxItem extends class_1792 {

	public ScrapBoxItem(String name) {
		super(TRItemSettings.item(name));
	}

	@Override
	public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (stack.method_31574(TRContent.SCRAP_BOX)) {
			if (world.method_8608()) {
				return class_1269.field_5812;
			}
			List<ScrapBoxRecipe> scrapboxRecipeList = RecipeUtils.getRecipes(world, ModRecipes.SCRAPBOX);
			int random = world.field_9229.method_43048(scrapboxRecipeList.size());
			class_1799 out = scrapboxRecipeList.get(random).outputs().get(0);
			WorldUtils.dropItem(out, world, player.method_24515());
			class_1799 copy = stack.method_7972();
			copy.method_7934(1);
			return class_1269.field_5812.method_61393(copy);
		}
		return class_1269.field_5811;
	}
}
