/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items;

import reborncore.common.chunkloading.ChunkLoaderManager;
import techreborn.component.TRDataComponentTypes;
import techreborn.init.TRItemSettings;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;

public class FrequencyTransmitterItem extends class_1792 {

	public FrequencyTransmitterItem(String name) {
		super(TRItemSettings.item(name).method_7889(1));
	}

	@Override
	public class_1269 method_7884(class_1838 context) {
		class_1937 world = context.method_8045();
		class_2338 pos = context.method_8037();
		class_1799 stack = context.method_8041();

		class_4208 globalPos = class_4208.method_19443(ChunkLoaderManager.getDimensionRegistryKey(world), pos);

		stack.method_57379(TRDataComponentTypes.FREQUENCY_TRANSMITTER, globalPos);

		if (context.method_8036() instanceof class_3222 serverPlayerEntity) {
			serverPlayerEntity.method_7353(class_2561.method_43471("techreborn.message.setTo")
											.method_10852(class_2561.method_43470(" X:").method_27692(class_124.field_1080))
											.method_10852(class_2561.method_43470(String.valueOf(pos.method_10263())).method_27692(class_124.field_1065))
											.method_10852(class_2561.method_43470(" Y:").method_27692(class_124.field_1080))
											.method_10852(class_2561.method_43470(String.valueOf(pos.method_10264())).method_27692(class_124.field_1065))
											.method_10852(class_2561.method_43470(" Z:").method_27692(class_124.field_1080))
											.method_10852(class_2561.method_43470(String.valueOf(pos.method_10260())).method_27692(class_124.field_1065))
											.method_27693(" ")
											.method_10852(class_2561.method_43471("techreborn.message.in").method_27692(class_124.field_1080))
											.method_27693(" ")
											.method_10852(class_2561.method_43470(getDimName(globalPos.comp_2207()).toString()).method_27692(class_124.field_1065)), true);
		}

		return class_1269.field_5812;
	}

	public static Optional<class_4208> getPos(class_1799 stack) {
		return Optional.ofNullable(stack.method_58694(TRDataComponentTypes.FREQUENCY_TRANSMITTER));
	}

	@Override
	public class_1269 method_7836(class_1937 world, class_1657 player,
											class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (player.method_5715()) {
			stack.method_57381(TRDataComponentTypes.FREQUENCY_TRANSMITTER);

			if (player instanceof class_3222 serverPlayerEntity) {
				serverPlayerEntity.method_7353(class_2561.method_43471("techreborn.message.coordsHaveBeen")
												.method_27692(class_124.field_1080)
												.method_27693(" ")
												.method_10852(
													class_2561.method_43471("techreborn.message.cleared")
														.method_27692(class_124.field_1065)
												), true);
			}
		}

		return class_1269.field_5812;
	}

	@Override
	public void method_67187(class_1799 stack, class_9635 context, class_10712 displayComponent, Consumer<class_2561> tooltip, class_1836 type) {
		getPos(stack)
			.ifPresent(globalPos -> {
				tooltip.accept(class_2561.method_43470(class_124.field_1080 + "X: " + class_124.field_1065 + globalPos.comp_2208().method_10263()));
				tooltip.accept(class_2561.method_43470(class_124.field_1080 + "Y: " + class_124.field_1065 + globalPos.comp_2208().method_10264()));
				tooltip.accept(class_2561.method_43470(class_124.field_1080 + "Z: " + class_124.field_1065 + globalPos.comp_2208().method_10260()));
				tooltip.accept(class_2561.method_43470(class_124.field_1063 + getDimName(globalPos.comp_2207()).toString()));
			});
	}

	private static class_2960 getDimName(class_5321<class_1937> dimensionRegistryKey) {
		return dimensionRegistryKey.method_29177();
	}
}
