/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items;

import org.jetbrains.annotations.Nullable;
import reborncore.common.powerSystem.RcEnergyItem;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.ItemUtils;
import techreborn.init.TRItemSettings;
import techreborn.utils.TRItemUtils;

import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class BatteryItem extends class_1792 implements RcEnergyItem {

	private final int maxEnergy;
	private final RcEnergyTier tier;

	public BatteryItem(int maxEnergy, RcEnergyTier tier, String name) {
		super(TRItemSettings.item(name).method_7889(1));
		this.maxEnergy = maxEnergy;
		this.tier = tier;
	}

	// Item
	@Override
	public class_1269 method_7836(final class_1937 world, final class_1657 player, final class_1268 hand) {
		final class_1799 stack = player.method_5998(hand);
		if (player.method_5715()) {
			TRItemUtils.switchActive(stack, 1, player);
			return class_1269.field_5812;
		}
		return class_1269.field_5811;
	}

	@Override
	public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
		TRItemUtils.checkActive(stack, 1, entity);
		if (world.method_8608()) {
			return;
		}
		if (!TRItemUtils.isActive(stack)){
			return;
		}
		if (entity instanceof class_1657) {
			ItemUtils.distributePowerToInventory((class_1657) entity, stack, tier.getMaxOutput(), (testStack) -> !(testStack.method_7909() instanceof BatteryItem));
		}
	}

	@Override
	public void method_67187(class_1799 stack, class_9635 context, class_10712 displayComponent, Consumer<class_2561> tooltip, class_1836 type) {
		TRItemUtils.buildActiveTooltip(stack, tooltip);
	}


	// ItemDurabilityExtensions
	@Override
	public int method_31569(class_1799 stack) {
		return ItemUtils.getPowerForDurabilityBar(stack);
	}

	@Override
	public boolean method_31567(class_1799 stack) {
		return true;
	}

	@Override
	public int method_31571(class_1799 stack) {
		return ItemUtils.getColorForDurabilityBar(stack);
	}

	// RcEnergyItem
	@Override
	public long getEnergyCapacity(class_1799 stack) {
		return maxEnergy;
	}

	@Override
	public RcEnergyTier getTier() {
		return tier;
	}

}
