/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.init;

import net.minecraft.class_9886;

/**
 * We use custom materials to allow LevelZ to tweak the mining level of our tools.
 */
public class TRToolMaterials {
	public static final class_9886 BASIC_CHAINSAW = copy(class_9886.field_52587, "basic_chainsaw");
	public static final class_9886 BASIC_DRILL = copy(class_9886.field_52587, "basic_drill");
	public static final class_9886 BASIC_JACKHAMMER = copy(class_9886.field_52588, "basic_jackhammer");

	public static final class_9886 ADVANCED_CHAINSAW = copy(class_9886.field_52588, "advanced_chainsaw");
	public static final class_9886 ADVANCED_DRILL = copy(class_9886.field_52588, "advanced_drill");
	public static final class_9886 ADVANCED_JACKHAMMER = copy(class_9886.field_52588, "advanced_jackhammer");

	public static final class_9886 INDUSTRIAL_CHAINSAW = copy(class_9886.field_52590, "industrial_chainsaw");
	public static final class_9886 INDUSTRIAL_DRILL = copy(class_9886.field_52590, "industrial_drill");
	public static final class_9886 INDUSTRIAL_JACKHAMMER = copy(class_9886.field_52590, "industrial_jackhammer");

	public static final class_9886 ROCK_CUTTER = copy(class_9886.field_52588, "rock_cutter");
	public static final class_9886 NANOSABER = copy(class_9886.field_52590, "nanosaber");
	public static final class_9886 OMNI_TOOL = copy(class_9886.field_52590, "omni_tool");

	public static class_9886 copy(class_9886 material, String id) {
		return new class_9886(material.comp_2930(), material.comp_2931(), material.comp_2932(), material.comp_2933(), material.comp_2934(), material.comp_2935());
	}
}
