/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.init;

import reborncore.common.crafting.RecipeUtils;
import reborncore.common.fluid.RebornBucketItem;
import reborncore.common.fluid.container.ItemFluidInfo;
import techreborn.TechReborn;
import techreborn.config.TechRebornConfig;
import techreborn.items.DynamicCellItem;
import techreborn.recipe.recipes.ScrapBoxRecipe;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;

/**
 * Created by drcrazy on 10-Jan-20 for TechReborn-1.15.
 */
public class TRDispenserBehavior {

	public static void init() {
		if (TechRebornConfig.dispenseScrapboxes) {
			class_2315.method_10009(TRContent.SCRAP_BOX, new class_2347() {
				public class_1799 method_10135(class_2342 pointer, class_1799 stack) {
					List<ScrapBoxRecipe> scrapboxRecipeList = RecipeUtils.getRecipes(pointer.comp_1967(), ModRecipes.SCRAPBOX);
					int random = class_5819.method_43047().method_43048(scrapboxRecipeList.size());
					class_1799 out = scrapboxRecipeList.get(random).outputs().getFirst().method_7972();
					stack.method_7971(1);

					class_2350 facing = pointer.comp_1969().method_11654(class_2315.field_10918);
					class_2374 position = class_2315.method_58682(pointer);
					method_10134(pointer.comp_1967(), out, 6, facing, position);
					return stack;
				}
			});
		}

		class_2315.method_10009(TRContent.CELL, new class_2347() {
			public class_1799 method_10135(class_2342 pointer, class_1799 stack) {
				DynamicCellItem cell = (DynamicCellItem) stack.method_7909();
				class_1936 iWorld = pointer.comp_1967();
				class_2338 blockPos = pointer.comp_1968().method_10093(pointer.comp_1969().method_11654(class_2315.field_10918));
				class_2680 blockState = iWorld.method_8320(blockPos);
				class_2248 block = blockState.method_26204();
				if (cell.getFluid(stack) == class_3612.field_15906) {
					// fill cell
					if (block instanceof class_2263) {
						class_1799 fluidContainer = ((class_2263) block).method_9700(null, iWorld, blockPos, blockState);
						class_3611 fluid = null;
						if (fluidContainer.method_7909() instanceof ItemFluidInfo) {
							fluid = ((ItemFluidInfo) fluidContainer.method_7909()).getFluid(fluidContainer);
						} else {
							TechReborn.LOGGER.debug("Could not get Fluid from ItemStack " + fluidContainer.method_7909());
						}
						if (!(fluid instanceof class_3609)) {
							return super.method_10135(pointer, stack);
						} else {
							class_1799 filledCell = DynamicCellItem.getCellWithFluid(fluid, 1);
							if (stack.method_7947() == 1) {
								stack = filledCell;
							} else {
								stack.method_7934(1);
								if (pointer.comp_1970().method_11075(filledCell).method_7947() < 0) {
									this.dispense(pointer, filledCell);
								}
							}
							return stack;
						}
					} else {
						return super.method_10135(pointer, stack);
					}
				} else {
					// drain cell
					if (cell.placeFluid(null, pointer.comp_1967(), blockPos, null, stack)) {
						class_1799 emptyCell = cell.getEmpty();
						if (stack.method_7947() == 1) {
							stack = emptyCell;
						} else {
							stack.method_7934(1);
							if (pointer.comp_1970().method_11075(emptyCell).method_7947() < 0) {
								this.dispense(pointer, emptyCell);
							}
						}
					}
					return stack;
				}
			}
		});

		for (ModFluids fluid : ModFluids.values()) {
			class_2315.method_10009(fluid, new class_2347() {
				public class_1799 method_10135(class_2342 pointer, class_1799 stack) {
					RebornBucketItem bucket = (RebornBucketItem) stack.method_7909();
					class_2338 blockPos = pointer.comp_1968().method_10093(pointer.comp_1969().method_11654(class_2315.field_10918));

					if (bucket.method_7731(null, pointer.comp_1967(), blockPos, null)) {
						class_1799 emptyBucket = new class_1799(class_1802.field_8550);
						if (stack.method_7947() == 1) {
							stack = emptyBucket;
						} else {
							stack.method_7934(1);
							if (pointer.comp_1970().method_11075(emptyBucket).method_7947() < 0) {
								this.dispense(pointer, emptyBucket);
							}
						}
					}
					return stack;
				}
			});
		}
	}
}
