/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.init;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5328;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;
import reborncore.common.fluid.FluidUtils;
import techreborn.items.DynamicCellItem;

public class TRCauldronBehavior {
	public static void init() {
		class_5620 FILL_CELL_WITH_LAVA = (state, world, pos, player, hand, stack) -> {
			if (!FluidUtils.isContainerEmpty(stack)) {
				return class_1269.field_52423;
			}

			return class_5620.method_32210(state, world, pos, player, hand, stack,
					DynamicCellItem.getCellWithFluid(class_3612.field_15908), (stateX) -> true, class_3417.field_15202);
		};

		class_5620 FILL_CELL_WITH_WATER = (state, world, pos, player, hand, stack) -> {
			if (!FluidUtils.isContainerEmpty(stack)) {
				return class_1269.field_52423;
			}

			return class_5620.method_32210(state, world, pos, player, hand, stack,
					DynamicCellItem.getCellWithFluid(class_3612.field_15910), (stateX) -> true, class_3417.field_15126);
		};

		class_5620 FILL_FROM_CELL = (state, world, pos, player, hand, stack) -> {
			class_3611 cellFluid = ((DynamicCellItem) stack.method_7909()).getFluid(stack);
			if (cellFluid == class_3612.field_15910) {
				return fillCauldronFromCell(world, pos, player, hand, stack,
						class_2246.field_27097.method_9564().method_11657(class_5556.field_27206, 3),
						class_3417.field_14834);
			} else if (cellFluid == class_3612.field_15908) {
				return fillCauldronFromCell(world, pos, player, hand, stack,
						class_2246.field_27098.method_9564(),
						class_3417.field_15010);
			}

			return class_1269.field_52423;
		};

		class_5620.field_27777.comp_1982().put(TRContent.CELL, FILL_CELL_WITH_LAVA);
		class_5620.field_27776.comp_1982().put(TRContent.CELL, FILL_CELL_WITH_WATER);
		class_5620.field_27775.comp_1982().put(TRContent.CELL, FILL_FROM_CELL);
	}

	static class_1269 fillCauldronFromCell(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack, class_2680 state, class_3414 soundEvent) {
		if (!world.method_8608()) {
			player.method_6122(hand, class_5328.method_30012(stack, player, new class_1799(TRContent.CELL)));
			player.method_7281(class_3468.field_15430);
			world.method_8501(pos, state);
			world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0F, 1.0F);
			world.method_33596(null, class_5712.field_28166, pos);
		}

		return class_1269.field_5812;
	}
}
