/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2023 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.init;

import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import techreborn.TechReborn;

public class TRBlockSettings {
	private static class_4970.class_2251 metal(String name) {
		return class_4970.class_2251.method_9637()
			.method_9626(class_2498.field_11533)
			.method_31710(class_3620.field_16005)
			.method_9629(2f, 2f)
			.method_63500(key(name));
	}

	public static class_4970.class_2251 machine(String name) {
		return metal(name);
	}

	public static class_4970.class_2251 nuke(String name) {
		return class_4970.class_2251.method_9637()
			.method_9629(2F, 2F)
			.method_31710(class_3620.field_16002)
			.method_63500(key(name));
	}

	public static class_4970.class_2251 reinforcedGlass(String name) {
		return class_4970.class_2251.method_9630(class_2246.field_10033)
			.method_9629(4f, 60f)
			.method_9626(class_2498.field_11544)
			.method_63500(key(name));
	}

	private static class_4970.class_2251 rubber(boolean noCollision, float hardness, float resistance, String name) {
		var settings = class_4970.class_2251.method_9637()
			.method_31710(class_3620.field_16017)
			.method_9629(hardness, resistance)
			.method_9626(class_2498.field_11547)
			.method_63500(key(name));

		if (noCollision) {
			settings.method_9634();
		}

		return settings;
	}

	private static class_4970.class_2251 rubber(float hardness, float resistance, String name) {
		return rubber(false, hardness, resistance, name);
	}

	public static class_4970.class_2251 rubberWood(String name) {
		return rubber(2f, 2f, name)
			.method_50013();
	}

	public static class_4970.class_2251 rubberWoodStripped(String name) {
		return rubberWood(name)
			.method_9629(2.0F, 15.0F);
	}

	public static class_4970.class_2251 rubberLeaves(String name) {
		return class_4970.class_2251.method_9630(class_2246.field_9988)
			.method_31710(class_3620.field_16017)
			.method_63500(key(name));
	}

	public static class_4970.class_2251 rubberSapling(String name) {
		return class_4970.class_2251.method_9630(class_2246.field_10217)
			.method_31710(class_3620.field_16017)
			.method_63500(key(name));
	}

	public static class_4970.class_2251 rubberLog(String name) {
		return class_4970.class_2251.method_9630(class_2246.field_10037)
			.method_9640()
			.method_31710(class_3620.field_16017)
			.method_63500(key(name));
	}

	public static class_4970.class_2251 rubberLogStripped(String name) {
		return rubberLog(name).method_9629(2.0F, 15.0F);
	}

	public static class_4970.class_2251 rubberSlab(String name) {
		return rubberLog(name);
	}

	public static class_4970.class_2251 rubberFence(String name) {
		return rubberLog(name);
	}

	public static class_4970.class_2251 rubberFenceGate(String name) {
		return rubberLog(name);
	}

	public static class_4970.class_2251 pottedRubberSapling(String name) {
		return class_4970.class_2251.method_9630(class_2246.field_10192)
			.method_63500(key(name));
	}

	public static class_4970.class_2251 copperWall(String name) {
		return class_4970.class_2251.method_9630(class_2246.field_27119)
			.method_9629(2f, 2f)
			.method_63500(key(name));
	}

	public static class_4970.class_2251 rubberTrapdoor(String name) {
		return rubber(3.0F, 3.0F, name);
	}

	public static class_4970.class_2251 rubberDoor(String name) {
		return rubber(3.0F, 3.0F, name);
	}

	public static class_4970.class_2251 rubberButton(String name) {
		return rubber(true, 0.5F, 0.5F, name);
	}

	public static class_4970.class_2251 rubberPressurePlate(String name) {
		return rubber(true, 0.5F, 0.5F, name);
	}

	public static class_4970.class_2251 refinedIronFence(String name) {
		return metal(name)
			.method_9629(2.0F, 3.0F);
	}

	public static class_4970.class_2251 storageBlock(boolean isHot, float hardness, float resistance, String name) {
		class_4970.class_2251 settings = class_4970.class_2251.method_9637()
			.method_9629(hardness, resistance)
			.method_31710(class_3620.field_16005) // TODO 1.20 maybe set the color based off the block?
			.method_9626(class_2498.field_11533)
			.method_63500(key(name));

		if (isHot) {
			settings = settings.method_9631(state -> 15)
				.method_22488();
		}

		return settings;
	}

	public static class_4970.class_2251 ore(boolean deepslate, String name) {
		return class_4970.class_2251.method_9637()
			.method_29292()
			.method_9626(deepslate ? class_2498.field_29033 : class_2498.field_11544)
			.method_36557(deepslate ? 4.5f : 3f)
			.method_36558(3f)
			.method_63500(key(name));
	}

	public static class_4970.class_2251 machineFrame(String name) {
		return metal(name)
			.method_9629(1f, 1f);
	}

	public static class_4970.class_2251 machineCasing(String name) {
		return metal(name)
			.method_9629(2f, 2f)
			.method_29292();
	}

	public static class_4970.class_2251 energyStorage(String name) {
		return metal(name);
	}

	public static class_4970.class_2251 lsuStorage(String name) {
		return metal(name);
	}

	public static class_4970.class_2251 storageUnit(boolean wooden, String name) {
		if (!wooden) {
			return metal(name);
		}

		return class_4970.class_2251.method_9637()
			.method_9626(class_2498.field_11547)
			.method_31710(class_3620.field_15996)
			.method_9629(2f, 2f)
			.method_63500(key(name));
	}

	public static class_4970.class_2251 fusionCoil(String name) {
		return metal(name);
	}

	public static class_4970.class_2251 transformer(String name) {
		return metal(name);
	}

	public static class_4970.class_2251 playerDetector(String name) {
		return metal(name);
	}

	public static class_4970.class_2251 fluid(String name) {
		return class_4970.class_2251.method_9630(class_2246.field_10382)
			.method_63500(key(name));
	}

	public static class_4970.class_2251 computerCube(String name) {
		return metal(name);
	}

	public static class_4970.class_2251 alarm(String name) {
		return metal(name);
	}

	public static class_4970.class_2251 genericMachine(String name) {
		return metal(name);
	}

	public static class_4970.class_2251 tankUnit(String name) {
		return metal(name);
	}

	public static class_4970.class_2251 fusionControlComputer(String name) {
		return metal(name);
	}

	public static class_4970.class_2251 solarPanel(String name) {
		return metal(name);
	}

	public static class_4970.class_2251 cable(String name) {
		return metal(name).method_9629(1f, 8f);
	}

	public static class_4970.class_2251 resinBasin(String name) {
		return class_4970.class_2251.method_9637()
			.method_31710(class_3620.field_15996)
			.method_9626(class_2498.field_11547)
			.method_9629(2F, 2F)
			.method_63500(key(name));
	}

	public static class_4970.class_2251 lightBlock(String name) {
		return class_4970.class_2251.method_9630(class_2246.field_10002)
			.method_9629(2f, 2f)
			.method_63500(key(name));
	}

	public static class_5321<class_2248> key(String name) {
		return class_5321.method_29179(class_7923.field_41175.method_46765(), class_2960.method_60655(TechReborn.MOD_ID, name));
	}
}
