/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.init;

import java.util.EnumMap;
import net.minecraft.class_10191;
import net.minecraft.class_10394;
import net.minecraft.class_156;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8051;


public class TRArmorMaterials {
	private static final class_6862<class_1792> EMPTY = class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("techreborn", "empty"));
	public static final class_1741 BRONZE = register("bronze", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
		map.put(class_8051.field_41937, 2);
		map.put(class_8051.field_41936, 5);
		map.put(class_8051.field_41935, 6);
		map.put(class_8051.field_41934, 3);
		map.put(class_8051.field_48838, 7);
	}), 8, class_3417.field_14862, 0.0f, 0.1f, 17, TRContent.Ingots.BRONZE.asTag());

	public static final class_1741 SILVER = register("silver", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
		map.put(class_8051.field_41937, 2);
		map.put(class_8051.field_41936, 5);
		map.put(class_8051.field_41935, 3);
		map.put(class_8051.field_41934, 1);
		map.put(class_8051.field_48838, 5);
	}), 15, class_3417.field_14761, 0.0f, 0.0f, 14, TRContent.Ingots.SILVER.asTag());

	public static final class_1741 STEEL = register("steel", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
		map.put(class_8051.field_41937, 2);
		map.put(class_8051.field_41936, 6);
		map.put(class_8051.field_41935, 5);
		map.put(class_8051.field_41934, 3);
		map.put(class_8051.field_48838, 11);
	}), 5, class_3417.field_14862, 1.75f, 0.1f, 24, TRContent.Ingots.STEEL.asTag());

	public static final class_1741 RUBY = register("ruby", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
		map.put(class_8051.field_41937, 2);
		map.put(class_8051.field_41936, 5);
		map.put(class_8051.field_41935, 7);
		map.put(class_8051.field_41934, 2);
		map.put(class_8051.field_48838, 7);
	}), 10, class_3417.field_15103, 0.0f, 0.0f, 16, TRContent.Gems.RUBY.asTag());

	public static final class_1741 SAPPHIRE = register("sapphire", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
		map.put(class_8051.field_41937, 4);
		map.put(class_8051.field_41936, 4);
		map.put(class_8051.field_41935, 4);
		map.put(class_8051.field_41934, 4);
		map.put(class_8051.field_48838, 7);
	}), 8, class_3417.field_15103, 0.0f, 0.0f, 19, TRContent.Gems.SAPPHIRE.asTag());

	public static final class_1741 PERIDOT = register("peridot", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
		map.put(class_8051.field_41937, 2);
		map.put(class_8051.field_41936, 3);
		map.put(class_8051.field_41935, 8);
		map.put(class_8051.field_41934, 3);
		map.put(class_8051.field_48838, 7);
	}), 16, class_3417.field_15103, 0.0f, 0.0f, 17, TRContent.Gems.PERIDOT.asTag());

	public static final class_1741 QUANTUM = register("quantum", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
		map.put(class_8051.field_41937, 3);
		map.put(class_8051.field_41936, 8);
		map.put(class_8051.field_41935, 6);
		map.put(class_8051.field_41934, 3);
		map.put(class_8051.field_48838, 11);
	}), 10, class_3417.field_15103, 2.0f, 0, 33, EMPTY);

	public static final class_1741 NANO = register("nano", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
		map.put(class_8051.field_41937, 1);
		map.put(class_8051.field_41936, 3);
		map.put(class_8051.field_41935, 2);
		map.put(class_8051.field_41934, 1);
		map.put(class_8051.field_48838, 3);
	}), 10, class_3417.field_15103, 0, 0, 33, EMPTY);

	public static final class_1741 CLOAKING_DEVICE = register("cloaking_device", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
		map.put(class_8051.field_41937, 0);
		map.put(class_8051.field_41936, 0);
		map.put(class_8051.field_41935, 2);
		map.put(class_8051.field_41934, 0);
		map.put(class_8051.field_48838, 0);
	}), 10, class_3417.field_14761, 0.0f, 0.0f, 33, EMPTY);

	public static final class_1741 LITHIUM_BATPACK = register("lithium_batpack", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
		map.put(class_8051.field_41937, 0);
		map.put(class_8051.field_41936, 0);
		map.put(class_8051.field_41935, 5);
		map.put(class_8051.field_41934, 0);
		map.put(class_8051.field_48838, 0);
	}), 10, class_3417.field_14684, 0.0f, 0.0f, 33, EMPTY);

	public static final class_1741 LAPOTRONIC_ORBPACK = register("lapotronic_orbpack", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
		map.put(class_8051.field_41937, 0);
		map.put(class_8051.field_41936, 0);
		map.put(class_8051.field_41935, 6);
		map.put(class_8051.field_41934, 0);
		map.put(class_8051.field_48838, 0);
	}), 10, class_3417.field_15103, 2.0f, 0.0f, 33, EMPTY);

	private static class_1741 register(String id, EnumMap<class_8051, Integer> defense, int enchantability, class_6880<class_3414> equipSound, float toughness, float knockbackResistance, int durability, class_6862<class_1792> repairIngredient) {
		class_5321<class_10394> asset = class_5321.method_29179(class_10191.field_55214, class_2960.method_60655("techreborn",  id));
		return new class_1741(durability, defense, enchantability, equipSound, toughness, knockbackResistance, repairIngredient, asset);
	}
}
