/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.init;

import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import reborncore.common.recipes.ICrafterSoundHandler;
import techreborn.config.TechRebornConfig;

/**
 * Created by Mark on 20/03/2016.
 */
public class ModSounds {

	public static class_3414 CABLE_SHOCK;
	public static class_3414 BLOCK_DISMANTLE;
	public static class_3414 SAP_EXTRACT;
	public static class_3414 AUTO_CRAFTING;
	public static class_3414 MACHINE_RUN;
	public static class_3414 MACHINE_START;
	public static class_3414 ALARM;
	public static class_3414 ALARM_2;
	public static class_3414 ALARM_3;

	public static class SoundHandler implements ICrafterSoundHandler {

		@Override
		public void playSound(boolean firstRun, class_2586 blockEntity) {
			class_1937 world = blockEntity.method_10997();
			if (world == null) {
				return;
			}

			world.method_43128(null, blockEntity.method_11016().method_10263(), blockEntity.method_11016().method_10264(),
					blockEntity.method_11016().method_10260(), ModSounds.MACHINE_RUN, class_3419.field_15245, TechRebornConfig.machineSoundVolume, 1F);
		}
	}
}
