/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.init;

import net.minecraft.class_2960;
import net.minecraft.class_3956;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RecipeManager;
import techreborn.recipe.recipes.AssemblingMachineRecipe;
import techreborn.recipe.recipes.BlastFurnaceRecipe;
import techreborn.recipe.recipes.CentrifugeRecipe;
import techreborn.recipe.recipes.FluidGeneratorRecipe;
import techreborn.recipe.recipes.FluidReplicatorRecipe;
import techreborn.recipe.recipes.FusionReactorRecipe;
import techreborn.recipe.recipes.IndustrialGrinderRecipe;
import techreborn.recipe.recipes.IndustrialSawmillRecipe;
import techreborn.recipe.recipes.RollingMachineRecipe;
import techreborn.recipe.recipes.ScrapBoxRecipe;

public class ModRecipes {
	public static final class_3956<RebornRecipe> ALLOY_SMELTER = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:alloy_smelter"));
	public static final class_3956<AssemblingMachineRecipe> ASSEMBLING_MACHINE = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:assembling_machine"), AssemblingMachineRecipe.CODEC, AssemblingMachineRecipe.PACKET_CODEC);
	public static final class_3956<BlastFurnaceRecipe> BLAST_FURNACE = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:blast_furnace"), BlastFurnaceRecipe.CODEC, BlastFurnaceRecipe.PACKET_CODEC);
	public static final class_3956<CentrifugeRecipe> CENTRIFUGE = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:centrifuge"), CentrifugeRecipe.CODEC, CentrifugeRecipe.PACKET_CODEC);
	public static final class_3956<RebornRecipe> CHEMICAL_REACTOR = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:chemical_reactor"));
	public static final class_3956<RebornRecipe> COMPRESSOR = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:compressor"));
	public static final class_3956<RebornRecipe> DISTILLATION_TOWER = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:distillation_tower"));
	public static final class_3956<RebornRecipe> EXTRACTOR = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:extractor"));
	public static final class_3956<RebornRecipe> GRINDER = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:grinder"));
	public static final class_3956<RebornRecipe> IMPLOSION_COMPRESSOR = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:implosion_compressor"));
	public static final class_3956<RebornRecipe> INDUSTRIAL_ELECTROLYZER = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:industrial_electrolyzer"));
	public static final class_3956<IndustrialGrinderRecipe> INDUSTRIAL_GRINDER = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:industrial_grinder"), IndustrialGrinderRecipe.CODEC, IndustrialGrinderRecipe.PACKET_CODEC);
	public static final class_3956<IndustrialSawmillRecipe> INDUSTRIAL_SAWMILL = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:industrial_sawmill"), IndustrialSawmillRecipe.CODEC, IndustrialSawmillRecipe.PACKET_CODEC);
	public static final class_3956<RebornRecipe> RECYCLER = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:recycler"));
	public static final class_3956<ScrapBoxRecipe> SCRAPBOX = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:scrapbox"), ScrapBoxRecipe.CODEC, ScrapBoxRecipe.PACKET_CODEC);
	public static final class_3956<RebornRecipe> VACUUM_FREEZER = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:vacuum_freezer"));
	public static final class_3956<FluidReplicatorRecipe> FLUID_REPLICATOR = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:fluid_replicator"), FluidReplicatorRecipe.CODEC, FluidReplicatorRecipe.PACKET_CODEC);
	public static final class_3956<FusionReactorRecipe> FUSION_REACTOR = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:fusion_reactor"), FusionReactorRecipe.CODEC, FusionReactorRecipe.PACKET_CODEC);
	public static final class_3956<RollingMachineRecipe> ROLLING_MACHINE = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:rolling_machine"), RollingMachineRecipe.CODEC, RollingMachineRecipe.PACKET_CODEC);
	public static final class_3956<RebornRecipe> SOLID_CANNING_MACHINE = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:solid_canning_machine"));
	public static final class_3956<RebornRecipe> WIRE_MILL = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:wire_mill"));
	public static final class_3956<FluidGeneratorRecipe> THERMAL_GENERATOR = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:thermal_generator"), FluidGeneratorRecipe.CODEC, FluidGeneratorRecipe.PACKET_CODEC);
	public static final class_3956<FluidGeneratorRecipe> GAS_GENERATOR = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:gas_generator"), FluidGeneratorRecipe.CODEC, FluidGeneratorRecipe.PACKET_CODEC);
	public static final class_3956<FluidGeneratorRecipe> DIESEL_GENERATOR = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:diesel_generator"), FluidGeneratorRecipe.CODEC, FluidGeneratorRecipe.PACKET_CODEC);
	public static final class_3956<FluidGeneratorRecipe> SEMI_FLUID_GENERATOR = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:semi_fluid_generator"), FluidGeneratorRecipe.CODEC, FluidGeneratorRecipe.PACKET_CODEC);
	public static final class_3956<FluidGeneratorRecipe> PLASMA_GENERATOR = RecipeManager.newRecipeType(class_2960.method_60654("techreborn:plasma_generator"), FluidGeneratorRecipe.CODEC, FluidGeneratorRecipe.PACKET_CODEC);
}
