/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.init;

import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_141;
import net.minecraft.class_149;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_77;
import net.minecraft.class_79;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRContent.Ingots;
import techreborn.init.TRContent.Parts;

public class ModLoot {

	public static void init() {

		class_79 copperIngot = makeEntry(class_1802.field_27022);
		class_79 tinIngot = makeEntry(Ingots.TIN);
		class_79 leadIngot = makeEntry(Ingots.LEAD);
		class_79 silverIngot = makeEntry(Ingots.SILVER);
		class_79 refinedIronIngot = makeEntry(Ingots.REFINED_IRON);
		class_79 advancedAlloyIngot = makeEntry(Ingots.ADVANCED_ALLOY);
		class_79 basicFrame = makeEntry(TRContent.MachineBlocks.BASIC.frame.method_8389());
		class_79 basicCircuit = makeEntry(Parts.ELECTRONIC_CIRCUIT);
		class_79 rubberSapling = makeEntry(TRContent.RUBBER_SAPLING, 25);

		class_55 poolBasic = class_55.method_347().with(copperIngot).with(tinIngot)
			.with(leadIngot).with(silverIngot).with(refinedIronIngot).with(advancedAlloyIngot)
			.with(basicFrame).with(basicCircuit).with(rubberSapling).method_352(class_5662.method_32462(1.0f, 2.0f))
			.method_355();

		class_79 aluminumIngot = makeEntry(Ingots.ALUMINUM);
		class_79 electrumIngot = makeEntry(Ingots.ELECTRUM);
		class_79 invarIngot = makeEntry(Ingots.INVAR);
		class_79 nickelIngot = makeEntry(Ingots.NICKEL);
		class_79 steelIngot = makeEntry(Ingots.STEEL);
		class_79 zincIngot = makeEntry(Ingots.ZINC);
		class_79 advancedFrame = makeEntry(TRContent.MachineBlocks.ADVANCED.frame.method_8389());
		class_79 advancedCircuit = makeEntry(Parts.ADVANCED_CIRCUIT);
		class_79 dataStorageChip = makeEntry(Parts.DATA_STORAGE_CHIP);

		class_55 poolAdvanced = class_55.method_347().with(aluminumIngot).with(electrumIngot)
			.with(invarIngot).with(nickelIngot).with(steelIngot).with(zincIngot)
			.with(advancedFrame).with(advancedCircuit).with(dataStorageChip).method_352(class_5662.method_32462(1.0f, 3.0f))
			.method_355();

		class_79 chromeIngot = makeEntry(Ingots.CHROME);
		class_79 iridiumIngot = makeEntry(Ingots.IRIDIUM);
		class_79 platinumIngot = makeEntry(Ingots.PLATINUM);
		class_79 titaniumIngot = makeEntry(Ingots.TITANIUM);
		class_79 tungstenIngot = makeEntry(Ingots.TUNGSTEN);
		class_79 tungstensteelIngot = makeEntry(Ingots.TUNGSTENSTEEL);
		class_79 industrialFrame = makeEntry(TRContent.MachineBlocks.INDUSTRIAL.frame.method_8389());
		class_79 industrialCircuit = makeEntry(Parts.INDUSTRIAL_CIRCUIT);
		class_79 energyFlowChip = makeEntry(Parts.ENERGY_FLOW_CHIP);

		class_55 poolIndustrial = class_55.method_347().with(chromeIngot).with(iridiumIngot)
				.with(platinumIngot).with(titaniumIngot).with(tungstenIngot).with(tungstensteelIngot)
				.with(industrialFrame).with(industrialCircuit).with(energyFlowChip).method_352(class_5662.method_32462(1.0f, 3.0f))
				.method_355();

		LootTableEvents.MODIFY.register((key, tableBuilder, source) -> {
			String stringId = key.method_29177().toString();
			if (!stringId.startsWith("minecraft:gameplay") && !stringId.startsWith("minecraft:chests")) {
				return;
			}

			if (TechRebornConfig.enableOverworldLoot) {
				switch (stringId) {
					case "minecraft:chests/abandoned_mineshaft",
						"minecraft:chests/desert_pyramid",
						"minecraft:chests/igloo_chest",
						"minecraft:chests/jungle_temple",
						"minecraft:chests/simple_dungeon",
						"minecraft:chests/shipwreck_treasure",
						"minecraft:chests/underwater_ruin_small",
						"minecraft:chests/village/village_weaponsmith",
						"minecraft:chests/village/village_armorer",
						"minecraft:chests/village/village_toolsmith"
						-> tableBuilder.pool(poolBasic);
					case "minecraft:chests/stronghold_corridor",
						"minecraft:chests/stronghold_crossing",
						"minecraft:chests/stronghold_library",
						"minecraft:chests/underwater_ruin_big",
						"minecraft:chests/pillager_outpost"
						-> tableBuilder.pool(poolAdvanced);
					case "minecraft:chests/woodland_mansion",
						"minecraft:chests/ancient_city"
						-> tableBuilder.pool(poolIndustrial);
					case "minecraft:archeology/trail_ruins_common"
						-> tableBuilder.modifyPools(poolBuilder -> poolBuilder.with(class_77.method_411(Parts.RUBBER).method_419()));
					case "minecraft:gameplay/cat_morning_gift"
						-> tableBuilder.modifyPools(poolBuilder -> poolBuilder.with(class_77.method_411(Parts.SCRAP).method_437(5).method_419()));
				}
			}

			if (TechRebornConfig.enableNetherLoot) {
				if (stringId.equals("minecraft:chests/nether_bridge") ||
						stringId.equals("minecraft:chests/bastion_bridge") ||
						stringId.equals("minecraft:chests/bastion_hoglin_stable") ||
						stringId.equals("minecraft:chests/bastion_treasure") ||
						stringId.equals("minecraft:chests/bastion_other")) {
					tableBuilder.pool(poolAdvanced);
				}
			}

			if (TechRebornConfig.enableEndLoot) {
				if (stringId.equals("minecraft:chests/end_city_treasure")) {
					tableBuilder.pool(poolIndustrial);
				}
			}

			if (TechRebornConfig.enableFishingJunkLoot) {
				if (stringId.equals("minecraft:gameplay/fishing/junk")) {
					class_79 rubber = class_77.method_411(Parts.RUBBER).method_437(10).method_419();
					class_79 treeTap = class_77.method_411(TRContent.TREE_TAP).method_437(10)
						.method_438(class_149.method_633(class_5662.method_32462(0.0f, 0.9f))).method_419();
					class_79 scrap = class_77.method_411(Parts.SCRAP).method_437(10).method_419();
					tableBuilder.modifyPools(poolBuilder -> poolBuilder
						.with(rubber).with(treeTap).with(scrap));
				}
			}
		});

	}

	/**
	 * Makes loot entry from item provided
	 *
	 * @param item {@link class_1935} Item to include into LootEntry
	 * @return {@link class_79} Entry for item provided
	 */
	private static class_79 makeEntry(class_1935 item) {
		return makeEntry(item, 5);
	}

	/**
	 * Makes loot entry from item provided with weight provided
	 *
	 * @param item   {@link class_1935} Item to include into LootEntry
	 * @param weight {@code int} Weight of that item
	 * @return {@link class_79} Entry for item and weight provided
	 */
	private static class_79 makeEntry(class_1935 item, int weight) {
		return class_77.method_411(item).method_437(weight)
				.method_438(class_141.method_621(class_5662.method_32462(1.0f, 2.0f))).method_419();
	}


}
