/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.events;

import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import techreborn.init.TRContent;

public class UseBlockHandler implements UseBlockCallback{

	public static void init() {
		UseBlockCallback.EVENT.register(new UseBlockHandler());
	}

	@Override
	public class_1269 interact(class_1657 playerEntity, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
		class_1799 stack = playerEntity.method_5998(hand);

		if (stack.method_7909() instanceof class_1743) {
			class_2338 pos = blockHitResult.method_17777();
			class_2680 hitState = world.method_8320(pos);
			class_2248 hitBlock = hitState.method_26204();

			class_2248 strippedBlock = null;
			if (hitBlock == TRContent.RUBBER_LOG) {
				strippedBlock = TRContent.RUBBER_LOG_STRIPPED;
			} else if (hitBlock == TRContent.RUBBER_WOOD) {
				strippedBlock = TRContent.STRIPPED_RUBBER_WOOD;
			}

			if (strippedBlock != null) {
				// Play stripping sound
				world.method_8396(playerEntity, pos, class_3417.field_14675, class_3419.field_15245, 1.0F, 1.0F);
				if (world.method_8608()) {
					return class_1269.field_5812;
				}

				world.method_8652(pos, strippedBlock.method_9564().method_11657(class_2465.field_11459, hitState.method_11654(class_2465.field_11459)), 11);

				// Damage axe
				stack.method_7970(1, playerEntity, class_1304.field_6173);
				return class_1269.field_5812;
			}
		}

		return class_1269.field_5811;
	}
}
