/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.events;

import net.minecraft.class_10289;
import net.minecraft.class_1863;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;
import techreborn.TechReborn;
import techreborn.init.TRContent;

import java.util.Collection;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class TRRecipeHandler {

	public static void unlockTRRecipes(class_3222 playerMP) {
		MinecraftServer server = playerMP.method_51469().method_8503();
		if (server == null) return;
		class_1863 recipeManager = server.method_3772();
		class_10289 preparedRecipes = recipeManager.field_54638;

		Collection<class_8786<?>> recipeList = preparedRecipes.method_64698(class_3956.field_17545).stream()
			.filter(TRRecipeHandler::isRecipeValid)
			.collect(Collectors.toCollection(ArrayList::new));
		playerMP.method_7254(recipeList);
	}

	private static boolean isRecipeValid(class_8786<class_3955> recipe) {
		if (recipe.comp_1932() == null) {
			return false;
		}
		if (!recipe.comp_1932().method_29177().method_12836().equals(TechReborn.MOD_ID)) {
			return false;
		}
		return recipe.comp_1933().method_61671().method_64675().stream()
			.noneMatch(ingredient -> ingredient.method_8093(TRContent.Parts.UU_MATTER.getStack()));
	}

}
