/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.events;

import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_9274;
import reborncore.api.events.ApplyArmorToDamageCallback;
import techreborn.config.TechRebornConfig;
import techreborn.items.armor.NanoSuitItem;
import techreborn.items.armor.QuantumSuitItem;

public class ApplyArmorToDamageHandler implements ApplyArmorToDamageCallback {

	public static void init() {
		ApplyArmorToDamageCallback.EVENT.register(new ApplyArmorToDamageHandler());
	}

	@Override
	public float applyArmorToDamage(class_1657 player, float amount) {
		double damageAbsorbed = 0.0d;
		for (class_1304 equipmentSlot : class_9274.field_49224) {
			if (equipmentSlot == class_1304.field_48824) continue;
			class_1799 stack = player.method_6118(equipmentSlot);
			class_1792 stackItem = stack.method_7909();
			if (stackItem instanceof NanoSuitItem item) {
				long energy = item.getStoredEnergy(stack);
				if (energy > TechRebornConfig.nanoArmorEnergyCost) {
					item.setStoredEnergy(stack, energy - TechRebornConfig.nanoArmorEnergyCost);
				} else if (energy != 0) {
					item.setStoredEnergy(stack, 0);
				}
				continue;
			}
			if (!(stackItem instanceof QuantumSuitItem item)) {
				continue;
			}

			double stackEnergy = item.getStoredEnergy(stack);
			if (stackEnergy == 0.0d) {
				continue;
			}

			double damageToAbsorb = Math.min(stackEnergy, amount * 0.2d);
			if (item.tryUseEnergy(stack, (long) (damageToAbsorb * TechRebornConfig.damageAbsorbCost))) {
				damageAbsorbed += damageToAbsorb;
			}
		}

		return amount - (float) damageAbsorbed;
	}
}
