/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.entities;

import net.minecraft.class_1259;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1541;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import reborncore.common.explosion.RebornExplosion;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRContent;

/**
 * Created by Mark on 13/03/2016.
 */
public class EntityNukePrimed extends class_1541 {
	@Nullable class_1309 owner;

	private final class_3213 bossBar = new class_3213(class_2561.method_43471("block.techreborn.nuke"), class_1259.class_1260.field_5784, class_1259.class_1261.field_5795);


	public EntityNukePrimed(class_1299<? extends EntityNukePrimed> type, class_1937 world) {
		super(type, world);
		method_6967(TechRebornConfig.nukeFuseTime);
	}

	public EntityNukePrimed(class_1937 world, double x, double y, double z, @Nullable class_1309 owner) {
		this(TRContent.ENTITY_NUKE, world);

		this.method_5814(x, y, z);
		double d = world.field_9229.method_43058() * 6.2831854820251465;
		this.method_18800(-Math.sin(d) * 0.02, 0.2f, -Math.cos(d) * 0.02);
		this.method_6967(80);
		this.field_6014 = x;
		this.field_6036 = y;
		this.field_5969 = z;
		this.owner = owner;
		method_6967(TechRebornConfig.nukeFuseTime);
	}

	@Nullable
	@Override
	public class_1309 method_24921() {
		return owner;
	}

	@Override
	public void method_5773() {
		if (!this.method_5740()) {
			this.method_18799(this.method_18798().method_1031(0.0D, -0.04D, 0.0D));
		}

		this.method_5784(class_1313.field_6308, this.method_18798());
		this.method_18799(this.method_18798().method_1021(0.98D));
		if (this.method_24828()) {
			this.method_18799(this.method_18798().method_18805(0.7D, -0.5D, 0.7D));
		}

		method_6967(method_6969() - 1);
		bossBar.method_5408((float) method_6969() / TechRebornConfig.nukeFuseTime);

		if (this.method_6969() <= 0) {
			this.method_5650(class_5529.field_26998);
			if (!this.method_73183().method_8608()) {
				this.explodeNuke();
			}
		} else {
			this.method_5876();
		}
	}

	public void explodeNuke() {
		if (!TechRebornConfig.nukeEnabled) {
			return;
		}
		RebornExplosion nukeExplosion = new RebornExplosion(method_24515(), (class_3218)method_73183(), TechRebornConfig.nukeRadius);
		nukeExplosion.setLivingBase(method_24921());
		nukeExplosion.method_61737();
	}

	@Override
	public void method_5837(class_3222 player) {
		super.method_5837(player);
		this.bossBar.method_14088(player);
	}

	@Override
	public void method_5742(class_3222 player) {
		super.method_5742(player);
		this.bossBar.method_14089(player);
	}
}
