/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2024 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.component;

import com.mojang.serialization.codecs.PrimitiveCodec;
import net.minecraft.class_2378;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_4208;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import techreborn.TechReborn;

public class TRDataComponentTypes {
	private static final class_9139<class_9129, class_2680> BLOCK_STATE_PACKET_CODEC = class_9139.method_56438((value, buf) -> buf.method_10794(class_2512.method_10686(value)), buf -> class_2512.method_10681(class_7923.field_41175, buf.method_10798()));

	public static final class_9331<Boolean> IS_ACTIVE =
		class_9331.<Boolean>method_57873().method_57881(PrimitiveCodec.BOOL).method_57882(class_9135.field_48547).method_57880();

	public static final class_9331<Boolean> AOE5 =
		class_9331.<Boolean>method_57873().method_57881(PrimitiveCodec.BOOL).method_57882(class_9135.field_48547).method_57880();

	public static final class_9331<class_4208> FREQUENCY_TRANSMITTER =
		class_9331.<class_4208>method_57873().method_57881(class_4208.field_25066).method_57882(class_4208.field_48451).method_57880();

	public static final class_9331<class_2680> PAINTING_COVER =
		class_9331.<class_2680>method_57873().method_57881(class_2680.field_24734).method_57882(BLOCK_STATE_PACKET_CODEC).method_57880();

	public static final class_9331<class_6880<class_3611>> FLUID =
		class_9331.<class_6880<class_3611>>method_57873().method_57881(class_7923.field_41173.method_40294()).method_57882(class_9135.method_56383(class_7924.field_41270)).method_57880();

	public static void init(){
		class_2378.method_10230(class_7923.field_49658, class_2960.method_60655(TechReborn.MOD_ID, "is_active"), IS_ACTIVE);
		class_2378.method_10230(class_7923.field_49658, class_2960.method_60655(TechReborn.MOD_ID, "aoe5"), AOE5);
		class_2378.method_10230(class_7923.field_49658, class_2960.method_60655(TechReborn.MOD_ID, "frequency_transmitter"), FREQUENCY_TRANSMITTER);
		class_2378.method_10230(class_7923.field_49658, class_2960.method_60655(TechReborn.MOD_ID, "painting_cover"), PAINTING_COVER);
		class_2378.method_10230(class_7923.field_49658, class_2960.method_60655(TechReborn.MOD_ID, "fluid"), FLUID);
	}
}
