/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.screen;

import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import reborncore.common.screen.slot.SlotFilteredVoid;
import reborncore.common.util.RebornInventory;
import techreborn.init.TRContent;

public class DestructoPackScreenHandler extends class_1703 {

	private final class_1657 player;
	private final RebornInventory<?> inv;

	public DestructoPackScreenHandler(int syncID, class_1657 player) {
		super(null, syncID);
		this.player = player;
		inv = new RebornInventory<>(1, "destructopack", 64, null);
		buildContainer();
	}

	@Override
	public class_1799 method_7601(class_1657 player, int index) {
		return class_1799.field_8037;
	}

	@Override
	public boolean method_7597(class_1657 arg0) {
		return true;
	}

	private void buildContainer() {
		this.method_7621(
				new SlotFilteredVoid(inv, 0, 80, 36, new class_1799[]{TRContent.Parts.MACHINE_PARTS.getStack()}));
		int i;

		for (i = 0; i < 3; ++i) {
			for (int j = 0; j < 9; ++j) {
				this.method_7621(new class_1735(player.method_31548(), j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
			}
		}

		for (i = 0; i < 9; ++i) {
			this.method_7621(new class_1735(player.method_31548(), i, 8 + i * 18, 142));
		}
	}
}
