/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.render.entitys;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import techreborn.blockentity.generator.basic.WindMillBlockEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class TurbineRenderer implements class_827<WindMillBlockEntity, TurbineRenderer.TurbineRenderState> {
	private static final Set<class_2350> ALL_DIRECTIONS = EnumSet.allOf(class_2350.class);
	private static final TurbineModel MODEL = TurbineModel.create();
	public static final class_2960 TEXTURE = class_2960.method_60654("techreborn:textures/block/machines/generators/wind_mill_turbine.png");

	public TurbineRenderer(class_5614.class_5615 ctx) {
	}

	@Override
	public @NotNull TurbineRenderState method_74335() {
		return new TurbineRenderState();
	}

	@Override
	public void extractRenderState(
		WindMillBlockEntity blockEntity,
		TurbineRenderState state,
		float tickDelta,
		class_243 vec3,
		@Nullable class_11683.class_11792 crumblingOverlay
	) {
		class_11954.method_74399(blockEntity, state, crumblingOverlay);
		class_2350 facing = blockEntity.getFacing();
		state.layer = class_1921.method_23572(TEXTURE);
		state.rotate = -facing.method_10160().method_10144() + 90;
		state.spin = blockEntity.bladeAngle + tickDelta * blockEntity.spinSpeed;
		state.light = class_761.method_23794(blockEntity.method_10997(), blockEntity.method_11016().method_10093(facing));
	}

	@Override
	public void submit(
		TurbineRenderState state,
		class_4587 matrixStack,
		class_11659 submitNodeCollector,
		class_12075 cameraRenderState
	) {
		matrixStack.method_22903();
		matrixStack.method_22904(0.5, 0, 0.5);
		matrixStack.method_22907(class_7833.field_40716.rotationDegrees(state.rotate));
		matrixStack.method_22904(0, -1, -0.56);
		submitNodeCollector.method_73489(MODEL, state.spin, matrixStack, state.layer, state.light, class_4608.field_21444, 0, state.field_62677);
		matrixStack.method_22909();
	}

	private static class TurbineModel extends class_3879<Float> {
		private static TurbineModel create() {
			class_630.class_628[] baseCuboids = {
					new class_630.class_628(0, 0, -2.0F, -2.0F, -1.0F, 4F, 4F, 2F, 0F, 0F, 0F, false, 64F, 64F, ALL_DIRECTIONS),
					new class_630.class_628(0, 6, -1.0F, -1.0F, -2.0F, 2F, 2F, 1F, 0F, 0F, 0F, false, 64F, 64F, ALL_DIRECTIONS)
			};

			class_630 base = new class_630(Arrays.asList(baseCuboids), new HashMap<>() {
				{
					class_630.class_628[] blade1Cuboids = {
							new class_630.class_628(0, 9, -24.0F, -1.0F, -0.5F, 24F, 2F, 1F, 0F, 0F, 0F, false, 64F, 64F, ALL_DIRECTIONS)
					};
					class_630 blade1 = new class_630(Arrays.asList(blade1Cuboids), Collections.emptyMap());
					blade1.method_2851(0.0F, 0.0F, 0.0F);
					setRotation(blade1, -0.5236F, 0.0F, 0.0F);
					put("blade1", blade1);

					class_630.class_628[] blade2Cuboids = {
							new class_630.class_628(0, 9, -24.0F, -1.0F, -0.5F, 24F, 2F, 1F, 0F, 0F, 0F, false, 64F, 64F, ALL_DIRECTIONS)
					};
					class_630 blade2 = new class_630(Arrays.asList(blade2Cuboids), Collections.emptyMap());
					blade2.method_2851(0.0F, 0.0F, 0.0F);
					setRotation(blade2, -0.5236F, 0.0F, 2.0944F);
					put("blade2", blade2);

					class_630.class_628[] blade3Cuboids = {
							new class_630.class_628(0, 9, -24.0F, -2.0F, -1.075F, 24F, 2F, 1F, 0F, 0F, 0F, false, 64F, 64F, ALL_DIRECTIONS)
					};
					class_630 blade3 = new class_630(Arrays.asList(blade3Cuboids), Collections.emptyMap());
					blade3.method_2851(0.0F, 0.0F, 0.0F);
					setRotation(blade3, -0.5236F, 0.0F, -2.0944F);
					put("blade3", blade3);
				}
			});
			base.method_2851(0.0F, 24.0F, 0.0F);

			return new TurbineModel(base, class_1921::method_23578);
		}

		private static void setRotation(class_630 model, float x, float y, float z) {
			model.field_3654 = x;
			model.field_3675 = y;
			model.field_3674 = z;
		}

		public TurbineModel(class_630 root, Function<class_2960, class_1921> layerFactory) {
			super(root, layerFactory);
		}

		@Override
		public void setupAnim(Float spin) {
			field_54014.field_3674 = spin;
		}

		@Override
		public void method_62100(class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
			field_54014.method_22698(matrices, vertices, light, overlay);
		}
	}

	public static class TurbineRenderState extends class_11954 {
		public class_1921 layer;
		public float rotate;
		public float spin;
		public int light;
	}
}
