/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.render.entitys;

import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5481;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import techreborn.blockentity.storage.item.StorageUnitBaseBlockEntity;

/**
 * Created by drcrazy on 07-Jan-20 for TechReborn-1.15.
 */
public class StorageUnitRenderer implements class_827<StorageUnitBaseBlockEntity, StorageUnitRenderer.StorageUnitRenderState> {
	private final class_10442 itemModelResolver;
	private final class_327 font;

	public StorageUnitRenderer(class_5614.class_5615 ctx) {
		this.itemModelResolver = ctx.comp_4536();
		this.font = ctx.comp_4540();
	}

	@Override
	public @NotNull StorageUnitRenderState method_74335() {
		return new StorageUnitRenderState();
	}

	@Override
	public void extractRenderState(
		StorageUnitBaseBlockEntity storage,
		StorageUnitRenderState state,
		float f,
		class_243 vec3,
		@Nullable class_11683.class_11792 crumblingOverlay
	) {
		class_11954.method_74399(storage, state, crumblingOverlay);
		if (storage.method_10997() == null) {
			return;
		}
		class_1799 stack = storage.getDisplayedStack();
		if (stack.method_7960()) {
			return;
		}
		// Item rendering
		state.direction = storage.getFacing();
		state.rotate = (state.direction.method_10161() - 2) * 90F;
		state.lightAbove = class_761.method_23794(storage.method_10997(), storage.method_11016().method_10093(storage.getFacing()));
		state.item = new class_10444();
		itemModelResolver.method_65598(state.item, stack, class_811.field_4319, storage.method_10997(), null, 0);
		// Text rendering
		state.count = class_2561.method_43470(String.valueOf(storage.storedAmount)).method_30937();
		state.countX = (float) (-font.method_30880(state.count) / 2);
		state.countY = -4f + 40;
		state.name = class_2561.method_43470(stack.method_7964().method_10858(18)).method_30937();
		state.nameX = (float) (-font.method_30880(state.name) / 2);
		state.nameY = -4f - 40;
	}

	@Override
	public void submit(
		StorageUnitRenderState state,
		class_4587 matrices,
		class_11659 submitNodeCollector,
		class_12075 cameraRenderState
	) {
		if (state.direction == null) {
			return;
		}
		// Item rendering
		matrices.method_22903();
		matrices.method_22907(class_7833.field_40716.rotationDegrees(state.rotate));
		matrices.method_22905(0.5F, 0.5F, 0.5F);
		switch (state.direction) {
			case field_11043, field_11039 -> matrices.method_46416(1, 1, 0);
			case field_11035 -> matrices.method_46416(-1, 1, -2);
			case field_11034 -> matrices.method_46416(-1, 1, 2);
		}
		state.item.method_65604(matrices, submitNodeCollector, state.lightAbove, class_4608.field_21444, 0);
		matrices.method_22909();
		// Text rendering
		matrices.method_22903();
		// Render item only on horizontal facing #2183
		if (class_2350.class_2353.field_11062.method_10182(state.direction)) {
			matrices.method_22904(0.5, 0.5, 0.5); // Translate center
			matrices.method_22907(class_7833.field_40716.rotationDegrees(-state.direction.method_10160().method_10144() + 90)); // Rotate depending on face
			matrices.method_22904(0, 0, -0.505); // Translate forward
		}
		matrices.method_22905(-0.01f, -0.01F, -0.01f);
		// Render item count
		submitNodeCollector.method_73478(matrices, state.countX, state.countY, state.count, false, class_327.class_6415.field_33993, state.field_62676, 0xFF000000, 0, 0);
		// Render name
		submitNodeCollector.method_73478(matrices, state.nameX, state.nameY, state.name, false, class_327.class_6415.field_33993, state.field_62676, 0xFF000000, 0, 0);
		matrices.method_22909();
	}

	public static class StorageUnitRenderState extends class_11954 {
		public class_2350 direction;
		public float rotate;
		public int lightAbove;
		public class_10444 item;
		public class_5481 count;
		public float countX;
		public float countY;
		public class_5481 name;
		public float nameX;
		public float nameY;
	}
}
