/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.render.entitys;

import net.minecraft.class_10075;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_957;
import org.jetbrains.annotations.NotNull;
import techreborn.entities.EntityNukePrimed;
import techreborn.init.TRContent;

/**
 * Created by Mark on 13/03/2016.
 */
public class NukeRenderer extends class_897<EntityNukePrimed, class_10075> {
	public NukeRenderer(class_5617.class_5618 ctx) {
		super(ctx);
		this.field_4673 = 0.5F;
	}

	@Override
	public @NotNull class_10075 method_55269() {
		return new class_10075();
	}

	@Override
	public void submit(class_10075 state, class_4587 matrixStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
		matrixStack.method_22903();
		matrixStack.method_22904(1D, 0.5D, 0);
		if (state.field_53596 < 10.0F) {
			float h = 1.0F - state.field_53596 / 10.0F;
			h = class_3532.method_15363(h, 0.0F, 1.0F);
			h *= h;
			h *= h;
			float j = 1.0F + h * 0.3F;
			matrixStack.method_22905(j, j, j);
		}

		matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0F));
		matrixStack.method_22904(-0.5D, -0.5D, 0.5D);
		if (state.field_53597 != null) {
			class_957.method_23190(state.field_53597, matrixStack, submitNodeCollector, state.field_61820, (int) state.field_53596 / 5 % 2 == 0, state.field_61821);
		}
		matrixStack.method_22909();
		super.method_3936(state, matrixStack, submitNodeCollector, cameraRenderState);
	}

	@Override
	public void extractRenderState(EntityNukePrimed entity, class_10075 state, float f) {
		super.method_62354(entity, state, f);
		state.field_53596 = (float) entity.method_6969() - f + 1.0F;
		state.field_53597 = TRContent.NUKE.method_9564();
	}
}
