/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.render.entitys;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import techreborn.blockentity.cable.CableBlockEntity;
import techreborn.blocks.cable.CableBlock;
import java.util.List;
import net.minecraft.class_10889;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_827;

public class CableCoverRenderer implements class_827<CableBlockEntity, CableCoverRenderer.CableCoverRenderState> {
	private final class_776 blockRenderDispatcher;

	public CableCoverRenderer(class_5614.class_5615 ctx) {
		this.blockRenderDispatcher = ctx.comp_4535();
	}

	@Override
	public @NotNull CableCoverRenderState method_74335() {
		return new CableCoverRenderState();
	}

	@Override
	public void extractRenderState(
		CableBlockEntity blockEntity,
		CableCoverRenderState state,
		float f,
		class_243 vec3,
		@Nullable class_11683.class_11792 crumblingOverlay
	) {
		class_11954.method_74399(blockEntity, state, crumblingOverlay);
		if (!blockEntity.method_11010().method_11654(CableBlock.COVERED) || blockEntity.method_10997() == null) {
			return;
		}
		final class_2680 renderData = blockEntity.getRenderData();
		state.cover = renderData != null ? renderData : class_2246.field_10161.method_9564();
		state.layer = class_4696.method_29359(state.cover);
		class_5819 random = class_5819.method_43047();
		random.method_43052(42L);
		state.parts = blockRenderDispatcher.method_3349(state.cover).method_68512(random);
		state.level = blockEntity.method_10997();
		state.blockRenderDispatcher = blockRenderDispatcher;
	}

	@Override
	public void submit(
		CableCoverRenderState state,
		class_4587 poseStack,
		class_11659 submitNodeCollector,
		class_12075 cameraRenderState
	) {
		if (state.layer != null) {
			submitNodeCollector.method_73483(poseStack, state.layer, state);
		}
	}

	public static class CableCoverRenderState extends class_11954 implements class_11659.class_11660 {
		public class_1921 layer;
		public List<class_10889> parts;
		public class_1937 level;
		public class_776 blockRenderDispatcher;
		public class_2680 cover;

		@Override
		public void render(class_4587.class_4665 pose, class_4588 consumer) {
			class_4587 matrices = new class_4587();
			matrices.method_23760().method_66521(pose);
			blockRenderDispatcher.method_3355(cover, field_62673, level, matrices, consumer, true, parts);
		}
	}
}
