/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.render;

import com.google.common.base.Charsets;
import techreborn.TechReborn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_793;
import net.minecraft.class_809;

public class ModelHelper {

	public static final class_809 DEFAULT_ITEM_TRANSFORMS = loadTransformFromJson(class_2960.method_60654("minecraft:models/item/generated"));
	public static final class_809 HANDHELD_ITEM_TRANSFORMS = loadTransformFromJson(class_2960.method_60654("minecraft:models/item/handheld"));

	public static class_809 loadTransformFromJson(class_2960 location) {
		try {

			return class_793.method_3437(getReaderForResource(location)).comp_3742();
		} catch (IOException exception) {
			TechReborn.LOGGER.warn("Can't load resource " + location);
			exception.printStackTrace();
			return null;
		}
	}

	public static Reader getReaderForResource(class_2960 location) throws IOException {
		class_2960 file = class_2960.method_60655(location.method_12836(), location.method_12832() + ".json");
		class_3298 resource = class_310.method_1551().method_1478().method_14486(file).orElseThrow();
		return new BufferedReader(new InputStreamReader(resource.method_14482(), Charsets.UTF_8));
	}

}
