/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2025 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.render;

import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.minecraft.class_10419;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10801;
import net.minecraft.class_10817;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_7775;
import net.minecraft.class_7923;
import techreborn.blocks.misc.BlockMachineCasing;
import techreborn.utils.DirectionUtils;

import java.util.List;

public record MachineCasingModel(class_10889 part) implements class_1087 {
	public static final String MODEL_PATH = "block/machines/structure/";
	@SuppressWarnings("deprecation")
	public static void resolveBlockStates(BlockStateResolver.Context context) {
		BlockMachineCasing block = (BlockMachineCasing) context.block();
		class_2960 model = class_7923.field_41175.method_10221(block).method_45138(MODEL_PATH);
		class_4730 alone = new class_4730(class_1059.field_5275, model);
		class_4730 start = new class_4730(class_1059.field_5275, model.method_48331("_start"));
		class_4730 middle = new class_4730(class_1059.field_5275, model.method_48331("_middle"));
		class_4730 end = new class_4730(class_1059.field_5275, model.method_48331("_end"));
		class_10419.class_10420.class_10421 builder = new class_10419.class_10420.class_10421();
		builder.method_65548(class_2350.field_11033.method_10151(), alone);
		builder.method_65548(class_2350.field_11036.method_10151(), alone);
		block.method_9595().method_11662().forEach(state -> {
			for (class_2350 direction : class_2350.class_2353.field_11062) {
				switch (DirectionUtils.getHorizontalPart(direction, state.method_11654(DirectionUtils.HORIZONTAL_NEIGHBORS))) {
					case ALONE -> builder.method_65548(direction.method_10151(), alone);
					case START -> builder.method_65548(direction.method_10151(), start);
					case MIDDLE -> builder.method_65548(direction.method_10151(), middle);
					case END -> builder.method_65548(direction.method_10151(), end);
				}
			}
			class_10419 textures = new class_10419.class_10423().method_65550(builder.method_65547()).method_65551(null);
			context.setModel(state, new Unbaked(model, textures, alone));
		});
	}

	@Override
	public void method_68513(class_5819 random, List<class_10889> parts) {
		parts.add(part);
	}

	@Override
	public class_1058 method_68511() {
		return part.comp_3752();
	}

	public record Unbaked(class_2960 id, class_10419 textures, class_4730 particle) implements class_1087.class_9979 {
		@Override
		public class_1087 method_65542(class_2680 state, class_7775 baker) {
			class_10819 model = baker.method_45872(id);
			class_10817 baked = model.method_68044().bake(textures, baker, class_1086.field_5350, model);
			return new MachineCasingModel(new class_10801(baked, model.method_68040(), baker.method_65732().method_65739(particle, model)));
		}

		@Override
		public Object method_62332(class_2680 state) {
			return this;
		}

		@Override
		public void method_62326(class_10103 resolver) {
			resolver.markDependency(id);
		}
	}
}
