/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.render;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import techreborn.TechReborn;

import java.util.*;
import java.util.function.Supplier;
import net.minecraft.class_10419;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11566;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7923;
import net.minecraft.class_811;

public class ItemBucketModel implements class_10439 {
	public static final class_2960 ID = class_2960.method_60655(TechReborn.MOD_ID, "model/bucket");
	public static final class_2960 BUCKET = class_2960.method_60655(TechReborn.MOD_ID, "item/bucket");
	public static final class_2960 BUCKET_BASE = BUCKET.method_48331("_base");
	public static final class_2960 BUCKET_BACKGROUND = BUCKET.method_48331("_background");
	private final class_1921 layer;
	private final class_10809 settings;
	private final Supplier<Triple<List<class_777>, Supplier<Vector3f[]>, Integer>> bake;

	public ItemBucketModel(class_10809 modelSettings, Supplier<Triple<List<class_777>, Supplier<Vector3f[]>, Integer>> quadsProvider) {
		layer = class_4722.method_29382();
		settings = modelSettings;
		bake = Suppliers.memoize(quadsProvider::get);
	}

	@Override
	public void method_65584(
		class_10444 state,
		class_1799 stack,
		class_10442 resolver,
		class_811 displayContext,
		@Nullable class_638 world,
		@Nullable class_11566 user,
		int seed
	) {
		state.method_70946(this);
		class_10444.class_10446 layerRenderState = state.method_65601();
		layerRenderState.method_67992(layer);
		Triple<List<class_777>, Supplier<Vector3f[]>, Integer> baked = bake.get();
		layerRenderState.method_67997().addAll(baked.getLeft());
		layerRenderState.method_67995(baked.getMiddle());
		layerRenderState.method_65613(1)[0] = baked.getRight();
		settings.method_68000(layerRenderState, displayContext);
	}

	public record Unbaked(class_3611 fluid) implements class_10439.class_10441 {
		public static final MapCodec<ItemBucketModel.Unbaked> CODEC = RecordCodecBuilder.mapCodec(
			instance -> instance.group(
				class_2960.field_25139.xmap(class_7923.field_41173::method_63535, class_7923.field_41173::method_10221)
					.fieldOf("fluid").forGetter(techreborn.client.render.ItemBucketModel.Unbaked::fluid)
			)
			.apply(instance, ItemBucketModel.Unbaked::new)
		);

		@Override
		public void method_62326(class_10103 resolver) {
			resolver.markDependency(BUCKET_BASE);
			resolver.markDependency(BUCKET_BACKGROUND);
		}

		@Override
		public @NotNull class_10439 method_65587(class_10440 context) {
			class_7775 baker = context.comp_3390();
			class_10819 backgroundModel = baker.method_45872(BUCKET_BACKGROUND);
			List<class_777> backgroundQuads = backgroundModel.method_68034(backgroundModel.method_68045(), baker, class_1086.field_5350).method_68048();
			class_10819 baseModel = baker.method_45872(BUCKET_BASE);
			class_10419 modelTextures = baseModel.method_68045();
			List<class_777> baseQuads = baseModel.method_68034(modelTextures, baker, class_1086.field_5350).method_68048();
			class_10809 modelSettings = class_10809.method_68001(baker, baseModel, modelTextures);
			return new ItemBucketModel(modelSettings, () -> {
				List<class_777> list = new ArrayList<>(backgroundQuads);
				Pair<class_1058, Integer> pair = ItemCellModel.Unbaked.parseFluid(fluid);
				if (pair != null) {
					list.addAll(ItemCellModel.Unbaked.bakeFluidQuads(baker, backgroundModel, pair.getLeft()));
					list.addAll(ItemCellModel.Unbaked.replaceTint(baseQuads, -1));
					return Triple.of(list, ItemCellModel.Unbaked.bakeVector(list), pair.getRight());
				} else {
					list.addAll(baseQuads);
					return Triple.of(list, ItemCellModel.Unbaked.bakeVector(list), -1);
				}
			});
		}

		@Override
		public @NotNull MapCodec<ItemBucketModel.Unbaked> method_65585() {
			return CODEC;
		}
	}
}
