/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2024 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.render;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_10494;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_811;
import team.reborn.energy.api.base.SimpleEnergyItem;
import techreborn.TechReborn;
import techreborn.component.TRDataComponentTypes;
import techreborn.items.BatteryItem;
import techreborn.items.FrequencyTransmitterItem;
import techreborn.items.armor.BatpackItem;
import techreborn.items.tool.ChainsawItem;
import techreborn.items.tool.industrial.NanosaberItem;

public record ActiveProperty() implements class_10494<PowerType> {
	public static class_2960 ID = class_2960.method_60655(TechReborn.MOD_ID, "active");
	public static Codec<PowerType> VALUE_CODEC = PowerType.CODEC;
	public static final class_10494.class_10495<ActiveProperty, PowerType> TYPE = class_10494.class_10495.method_65686(
		MapCodec.unit(new ActiveProperty()), PowerType.CODEC
	);

	@Override
	public PowerType method_65676(
		class_1799 stack, class_638 world, class_1309 entity, int seed, class_811 mode
	) {
		class_1792 item = stack.method_7909();
		if (item instanceof NanosaberItem nanosaber) {
			if (stack.method_58694(TRDataComponentTypes.IS_ACTIVE) != Boolean.TRUE) return PowerType.OFF;
			if ((double) nanosaber.getStoredEnergy(stack) / nanosaber.getEnergyCapacity(stack) <= 0.1) return PowerType.LOW;
			return PowerType.ON;
		} else if (item instanceof ChainsawItem chainsaw) {
			if (SimpleEnergyItem.getStoredEnergyUnchecked(stack) < chainsaw.getCost()) return PowerType.OFF;
			if (entity == null || !entity.method_6047().equals(stack)) return PowerType.OFF;
			return PowerType.ON;
		} else if (item instanceof BatteryItem || item instanceof BatpackItem) {
			return SimpleEnergyItem.getStoredEnergyUnchecked(stack) == 0 ? PowerType.OFF : PowerType.ON;
		} else if (item instanceof FrequencyTransmitterItem) {
			return stack.method_58694(TRDataComponentTypes.FREQUENCY_TRANSMITTER) == null ? PowerType.OFF : PowerType.ON;
		}
		return PowerType.OFF;
	}

	@Override
	public class_10494.class_10495<ActiveProperty, PowerType> method_65674() {
		return TYPE;
	}

	@Override
	public Codec<PowerType> method_67287() {
		return VALUE_CODEC;
	}
}
