/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.keybindings;

import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_304.class_11900;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import techreborn.packets.serverbound.QuantumSuitSprintPayload;
import techreborn.packets.serverbound.SuitNightVisionPayload;

import static techreborn.TechReborn.MOD_ID;

public class KeyBindings {
	// Actual keybindings are in TechRebornClient
	public static final class_11900 CATEGORY = new class_11900(class_2960.method_60655(MOD_ID, "main"));

	public static class_304 suitNightVision;
	public static class_304 quantumSuitSprint;

	public static void registerKeys() {
		suitNightVision = KeyBindingHelper.registerKeyBinding(
			new class_304("key.techreborn.suitNightVision",
				class_3675.class_307.field_1668,
				GLFW.GLFW_KEY_N,
				CATEGORY));

		quantumSuitSprint = KeyBindingHelper.registerKeyBinding(
			new class_304("key.techreborn.quantumSuitSprint",
				class_3675.class_307.field_1668,
				GLFW.GLFW_KEY_R,
				CATEGORY));
	}

	public static void handleSuitNVToggle() {
		ClientPlayNetworking.send(new SuitNightVisionPayload());
	}

	public static void handleQuantumSuitSprintToggle() {
		ClientPlayNetworking.send(new QuantumSuitSprintPayload());
	}
}
