/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import reborncore.client.gui.GuiBase;
import reborncore.common.fluid.FluidUtils;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.screen.BuiltScreenHandler;
import techreborn.blockentity.storage.fluid.TankUnitBaseBlockEntity;

public class GuiTankUnit extends GuiBase<BuiltScreenHandler> {

	final TankUnitBaseBlockEntity tankEntity;

	public GuiTankUnit(int syncID, final class_1657 player, final TankUnitBaseBlockEntity tankEntity) {
		super(player, tankEntity, tankEntity.createScreenHandler(syncID, player));
		this.tankEntity = tankEntity;
	}

	@Override
	protected void method_2389(class_332 drawContext, final float f, final int mouseX, final int mouseY) {
		super.method_2389(drawContext, f, mouseX, mouseY);
		final GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;

		// Draw slots
		drawSlot(drawContext, 100, 53, layer);
		drawSlot(drawContext, 140, 53, layer);
	}

	@Override
	protected void method_2388(class_332 drawContext, final int mouseX, final int mouseY) {
		super.method_2388(drawContext, mouseX, mouseY);

		// Draw input/out
		builder.drawText(drawContext, this, class_2561.method_43471("gui.techreborn.unit.in"), 100, 43, theme.titleColor().comp_1971());
		builder.drawText(drawContext, this, class_2561.method_43471("gui.techreborn.unit.out"), 140, 43, theme.titleColor().comp_1971());


		FluidInstance fluid = tankEntity.getTank().getFluidInstance();

		if (fluid.isEmpty()) {
			drawContext.method_51439(field_22793, class_2561.method_43471("techreborn.tooltip.unit.empty"), 10, 20, theme.titleColor().comp_1971(), false);
		} else {
			drawContext.method_51439(field_22793, class_2561.method_43471("gui.techreborn.tank.type"), 10, 20, theme.titleColor().comp_1971(), false);
			drawContext.method_51433(field_22793, FluidUtils.getFluidName(fluid).replace("_", " "), 10, 30, theme.titleColor().comp_1971(), false);


			drawContext.method_51439(field_22793, class_2561.method_43471("gui.techreborn.tank.amount"), 10, 50, theme.titleColor().comp_1971(), false);
			drawContext.method_51433(field_22793, fluid.getAmount().toString(), 10, 60, theme.titleColor().comp_1971(), false);

			String percentFilled = String.valueOf((int) ((double) fluid.getAmount().getRawValue() / (double) tankEntity.getTank().getFluidValueCapacity().getRawValue() * 100));

			drawContext.method_51439(field_22793, class_2561.method_43471("gui.techreborn.unit.used").method_27693(percentFilled + "%"), 10, 70, theme.titleColor().comp_1971(), false);

			drawContext.method_51439(field_22793, class_2561.method_43471("gui.techreborn.unit.wrenchtip"), 10, 80, theme.warningTextColor().comp_1971(), false);
		}
	}

	@Override
	public void method_25394(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
		super.method_25394(drawContext, mouseX, mouseY, partialTicks);
		method_2380(drawContext, mouseX, mouseY);
	}
}
