/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.widget.GuiButtonUpDown;
import reborncore.common.screen.BuiltScreenHandler;
import techreborn.blockentity.machine.tier2.PumpBlockEntity;
import techreborn.packets.serverbound.PumpDepthPayload;
import techreborn.packets.serverbound.PumpRangePayload;

public class GuiPump extends GuiBase<BuiltScreenHandler> {

	private final PumpBlockEntity blockEntity;

	public GuiPump(int syncID, final class_1657 player, final PumpBlockEntity blockEntity) {
		super(player, blockEntity, blockEntity.createScreenHandler(syncID, player));
		this.blockEntity = blockEntity;
	}

	@Override
	public void method_25426() {
		super.method_25426();

		method_37063(new GuiButtonUpDown(field_2776 + 84, field_2800 + 30, this, b -> onClickDepth(10), GuiButtonUpDown.UpDownButtonType.FASTFORWARD));
		method_37063(new GuiButtonUpDown(field_2776 + 84 + 12, field_2800 + 30, this, b -> onClickDepth(1), GuiButtonUpDown.UpDownButtonType.FORWARD));
		method_37063(new GuiButtonUpDown(field_2776 + 84 + 24, field_2800 + 30, this, b -> onClickDepth(-1), GuiButtonUpDown.UpDownButtonType.REWIND));
		method_37063(new GuiButtonUpDown(field_2776 + 84 + 36, field_2800 + 30, this, b -> onClickDepth(-10), GuiButtonUpDown.UpDownButtonType.FASTREWIND));

		method_37063(new GuiButtonUpDown(field_2776 + 84, field_2800 + 55, this, b -> onClick(10), GuiButtonUpDown.UpDownButtonType.FASTFORWARD));
		method_37063(new GuiButtonUpDown(field_2776 + 84 + 12, field_2800 + 55, this, b -> onClick(1), GuiButtonUpDown.UpDownButtonType.FORWARD));
		method_37063(new GuiButtonUpDown(field_2776 + 84 + 24, field_2800 + 55, this, b -> onClick(-1), GuiButtonUpDown.UpDownButtonType.REWIND));
		method_37063(new GuiButtonUpDown(field_2776 + 84 + 36, field_2800 + 55, this, b -> onClick(-10), GuiButtonUpDown.UpDownButtonType.FASTREWIND));
	}

	private void onClickDepth(int amount) {
		ClientPlayNetworking.send(new PumpDepthPayload(blockEntity.method_11016(), amount));
	}

	private void onClick(int amount) {
		ClientPlayNetworking.send(new PumpRangePayload(blockEntity.method_11016(), amount));
	}

	@Override
	protected void method_2389(class_332 drawContext, final float partialTicks, final int mouseX, final int mouseY) {
		super.method_2389(drawContext, partialTicks, mouseX, mouseY);
		final Layer layer = Layer.BACKGROUND;

		if (hideGuiElements()) return;

		drawSlot(drawContext, 8, 72, layer); // Battery slot

		drawText(drawContext,
			class_2561.method_43469("gui.techreborn.pump.depth", Integer.toString(PumpBlockEntity.MIN_DEPTH), Integer.toString(PumpBlockEntity.MAX_DEPTH))
				.method_27693(Integer.toString(blockEntity.getDepth())),
			80, 20, 0xff404040, layer);
		drawText(drawContext,
			class_2561.method_43469("gui.techreborn.pump.range", Integer.toString(PumpBlockEntity.MIN_RANGE), Integer.toString(PumpBlockEntity.MAX_RANGE))
				.method_27693(Integer.toString(blockEntity.getRange())),
			80, 45, 0xff404040, layer);

		if (blockEntity.getExhausted()) {
			drawText(drawContext, class_2561.method_43471("gui.techreborn.pump.exhausted"), 80, 75, 0xff800000, layer);
		}
	}

	@Override
	protected void method_2388(class_332 drawContext, final int mouseX, final int mouseY) {
		super.method_2388(drawContext, mouseX, mouseY);
		final Layer layer = Layer.FOREGROUND;

		builder.drawTank(drawContext, this, 33, 25, mouseX, mouseY, blockEntity.getTank().getFluidInstance(), blockEntity.getTank().getFluidValueCapacity(), blockEntity.getTank().isEmpty(), layer);
		builder.drawMultiEnergyBar(drawContext, this, 9, 19, (int) blockEntity.getEnergy(), (int) blockEntity.getMaxStoredPower(), mouseX, mouseY, 0, layer);
	}
}
