/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.widget.GuiButtonUpDown;
import reborncore.common.screen.BuiltScreenHandler;
import techreborn.blockentity.machine.tier1.PlayerDetectorBlockEntity;
import techreborn.packets.serverbound.DetectorRadiusPayload;

public class GuiPlayerDetector extends GuiBase<BuiltScreenHandler> {

	final PlayerDetectorBlockEntity blockEntity;

	public GuiPlayerDetector(int syncID, final class_1657 player, final PlayerDetectorBlockEntity blockEntity) {
		super(player, blockEntity, blockEntity.createScreenHandler(syncID, player));
		this.blockEntity = blockEntity;
	}

	private void onClick(int amount) {
		ClientPlayNetworking.send(new DetectorRadiusPayload(blockEntity.method_11016(), amount));
	}

	@Override
	public void method_25426() {
		super.method_25426();

		method_37063(new GuiButtonUpDown(field_2776 + 64, field_2800 + 40, this, b -> onClick(16), GuiButtonUpDown.UpDownButtonType.FASTFORWARD));
		method_37063(new GuiButtonUpDown(field_2776 + 64 + 12, field_2800 + 40, this, b -> onClick(1), GuiButtonUpDown.UpDownButtonType.FORWARD));
		method_37063(new GuiButtonUpDown(field_2776 + 64 + 24, field_2800 + 40, this, b -> onClick(-1), GuiButtonUpDown.UpDownButtonType.REWIND));
		method_37063(new GuiButtonUpDown(field_2776 + 64 + 36, field_2800 + 40, this, b -> onClick(-16), GuiButtonUpDown.UpDownButtonType.FASTREWIND));
	}

	@Override
	protected void method_2389(class_332 drawContext, float partialTicks, int mouseX, int mouseY) {
		super.method_2389(drawContext, partialTicks, mouseX, mouseY);
		final Layer layer = Layer.BACKGROUND;

		if (hideGuiElements()) return;

		class_2561 text = class_2561.method_43470("Radius: ").method_27693(String.valueOf(blockEntity.getCurrentRadius()));
		drawCentredText(drawContext, text, 25, theme.titleColor().comp_1971(), layer);
	}

	@Override
	protected void method_2388(class_332 drawContext, final int mouseX, final int mouseY) {
		super.method_2388(drawContext, mouseX, mouseY);
		final Layer layer = Layer.FOREGROUND;

		builder.drawMultiEnergyBar(drawContext, this, 9, 19, (int) blockEntity.getEnergy(), (int) blockEntity.getMaxStoredPower(), mouseX, mouseY, 0, layer);
	}

}
